package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;

import java.math.BigDecimal;

/**
* 工作计划模板
*
* @author duwh
* @date 2022-12-15
*/
@Data
public class TimesheetPlanTempQuery extends TwQueryParam{
    /** 精确 */
    @Query
    private Long taskId;
    @Query(type = Query.Type.NOT_EQUAL, propName = "id")
    private Long idNotEqual;
    /** 精确 */
    @Query
    private Long planId;
    /** 精确 */
    @Query
    private String status;
    /** 精确 */
    @Query
    private String ext1;
    /** 精确 */
    @Query
    private String ext2;
    /** 精确 */
    @Query
    private String ext3;
    /** 精确 */
    @Query
    private String ext4;
    /** 精确 */
    @Query
    private String ext5;
    /** 精确 */
    @Query
    private String type;
    /** 精确 */
    @Query
    private Long projId;
    /** 精确 */
    @Query
    private Long projIdV4;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String projName;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String projNo;
    /**
     * 事由id
     */
    @Query
    private Long reasonId;
    /**
     * 事由名称
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String reasonName;
    /**
     * 事由类型 01 项目 02 售前 03 bu
     */
    @Query
    private String reasonType;
    /** 任务包id */
    @Query
    private Long taskPackageId;
    /** 任务包编号 冗余 */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskPackageNo;
    /** 任务包名称冗余 */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskPackageName;
    /** 精确 */
    @Query
    private Long taskIdV4;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskNo;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String taskName;
    /** 任务包申请状态 */
    @Query
    private String taskApplyStatus;
    /** 精确 */
    @Query
    private BigDecimal eqvaQty;
    @Query
    private Long createUserId;
    /** 精确 */
    @Query
    private Long actId;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String actName;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String actNo;
}
