package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitesland.tw.tw5.api.prd.my.payload.AbnormalWorkApplyConfigPayload;
import com.elitesland.tw.tw5.api.prd.my.query.AbnormalWorkApplyConfigQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.AbnormalWorkApplyConfigVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 远程办公审批配置
 *
 * @author wangly
 * @date 2024-06-13
 */
public interface AbnormalWorkApplyConfigService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AbnormalWorkApplyConfigVO}>
     */
    PagingVO<AbnormalWorkApplyConfigVO> queryPaging(AbnormalWorkApplyConfigQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AbnormalWorkApplyConfigVO}>
     */
    List<AbnormalWorkApplyConfigVO> queryListDynamic(AbnormalWorkApplyConfigQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AbnormalWorkApplyConfigVO}
     */
    AbnormalWorkApplyConfigVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link AbnormalWorkApplyConfigVO}
     */
    AbnormalWorkApplyConfigVO insert(AbnormalWorkApplyConfigPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AbnormalWorkApplyConfigVO}
     */
    AbnormalWorkApplyConfigVO update(AbnormalWorkApplyConfigPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AbnormalWorkApplyConfigPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
