package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 工时用-任务表
 * <p>
 * 注意： 业务代码中大都使用的taskIdV4 代表主键
 *
 * @author duwh
 * @date 2022-12-10
 */
@Data
public class TaskVO extends BaseViewModel {
    /**
     * 4.0任务主键
     */
    private Long taskIdV4;
    /**
     * 任务编号
     */
    private String taskNo;
    /**
     * 任务名称
     */
    private String taskName;
    /**
     * 活动列表
     */
    private List<ResActivityVO> activityList;
    /**
     * 任务状态 - T_TASK.TASK_STATUS
     * <p>
     * UDC:TSK:TASK_STATUS
     * <p>
     * 新建	CREATE
     * 派发中 DISPATCH
     * 处理中 IN PROCESS
     * 暂挂	PENDING
     * 验收中 VALIDATING
     * 完成	FINISHED
     * 关闭	CLOSED
     */
    private String taskStatus;
    /**
     * 发包资源id
     */
    private Long disterUserId;
    /**
     * 费用承担bu_id
     */
    private Long expenseBuId;
    /**
     * 接收资源bu_id
     */
    private Long receiverBuId;
    /**
     * 接收资源id
     */
    private Long receiverUserId;
    /**
     * 事由类型 01 项目 02 售前 03 bu
     */
    private String reasonType;
    /**
     * 事由id
     */
    private Long reasonId;
    /**
     * 4.0事由id
     */
    private Long reasonIdv4;
    /**
     * 事由名称冗余
     */
    private String reasonName;

    /**
     * 计划开始日期
     */
    private LocalDate planStartDate;
    /**
     * 计划结束日期
     */
    private LocalDate planEndDate;
    /**
     * 验收方式  TW4.0 - T_TASK.ACCEPT_METHOD
     * 枚举 TskEnums.AcceptMethod
     * 01 任务包  02 里程碑  03 活动  04 人天
     */
    private String acceptMethod;
    /**
     * 计价方式
     */
    private String pricingMethod;
    /**
     * 派发人天数
     */
    private BigDecimal days;
    /**
     * bu结算价
     */
    private BigDecimal buSettlePrice;
    /**
     * 派发当量系数
     */
    private BigDecimal eqvaRatio;
    /**
     * 总当量数
     */
    private BigDecimal eqvaQty;
    /**
     * 当量结算单价
     */
    private BigDecimal settlePrice;
    /**
     * 已结算当量数
     */
    private BigDecimal settledEqva;
    /**
     * 已结算人天数
     */
    private BigDecimal settledDays;
    /**
     * 已结算金额
     */
    private BigDecimal settledAmt;
    /**
     * 任务包类型
     */
    private String taskPackageType;
    /**
     * 任务来源类型
     */
    private String taskSourceType;
    /**
     * 任务包关闭时间
     */
    private LocalDateTime closedTime;
    /**
     * 定时任务自动结算当量标记
     */
    private Integer autoSettleFlag;
    /**
     * 发包日期
     */
    private LocalDate distDate;
    /** 追加当量;记录任务包当量变更流程累计追加的当量 */
    //private BigDecimal addEqva;
    /** 原始发包当量；用于记录第一次任务包派发流程审批通过时的任务包当量 */
    //private BigDecimal baseTaskEqva;
    /**
     * 拓展1
     */
    private String ext1;
    /**
     * 拓展2
     */
    private String ext2;
    /**
     * 拓展3
     */
    private String ext3;
    /**
     * 拓展4
     */
    private String ext4;
    /**
     * 拓展5
     */
    private String ext5;

    /**
     * 已填工时当量
     */
    private BigDecimal usedEqva;

    /**
     * 工时填报剩余可用当量
     */
    private BigDecimal effectiveEqva;

    public BigDecimal getEffectiveEqva() {
        if (null == effectiveEqva) {
            effectiveEqva = BigDecimal.ZERO;
        }
        return effectiveEqva;
    }

    private BigDecimal addEqva;//追加当量;记录任务包当量变更流程累计追加的当量
    private BigDecimal baseTaskEqva;//原始发包当量；用于记录第一次任务包派发流程审批通过时的任务包当量;原任务包当量在前端界面隐藏，仅用于任务包的结算
    private BigDecimal tsUsedEqva;// 已填工时当量=sum(当量系数*工时/8)
    private BigDecimal tsEffectiveEqva;//工时填报剩余可用当量=原始发包当量+追加当量-已填工时当量

    //任务包剩余可用于填报工时的当量
    public BigDecimal getTsEffectiveEqva() {// 必须先计算 tsUsedEqva在调用get方法
        BigDecimal baseTaskEqvaTmp = this.baseTaskEqva != null ? this.baseTaskEqva : BigDecimal.ZERO;
        BigDecimal addEqvaTmp = this.addEqva != null ? this.addEqva : BigDecimal.ZERO;
        BigDecimal tsUsedEqvaTmp = this.tsUsedEqva != null ? this.tsUsedEqva : BigDecimal.ZERO;
        return baseTaskEqvaTmp.add(addEqvaTmp).subtract(tsUsedEqvaTmp);
    }


}
