package com.elitesland.tw.tw5.api.prd.personplan.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.payload.PersonPlanVersionPayload;
import com.elitesland.tw.tw5.api.prd.personplan.query.PersonPlanVersionQuery;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PersonPlanVersionVO;

import java.util.List;

/**
 * 人员规划版本
 *
 * @author wangly
 * @date 2024-04-07
 */
public interface PersonPlanVersionService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PersonPlanVersionVO}>
     */
    PagingVO<PersonPlanVersionVO> queryPaging(PersonPlanVersionQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PersonPlanVersionVO}>
     */
    List<PersonPlanVersionVO> queryListDynamic(PersonPlanVersionQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PersonPlanVersionVO}
     */
    PersonPlanVersionVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link Long}
     */
    Long save(PersonPlanVersionPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PersonPlanVersionVO}
     */
    PersonPlanVersionVO update(PersonPlanVersionPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PersonPlanVersionPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
