package com.elitesland.tw.tw5.api.prd.pms.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;


/**
 * 项目模板
 *
 * @author xxb
 * @date 2023-08-02
 */
@Getter
@Setter
public class PmsProjectTemplateVO extends BaseViewModel implements Serializable {

    /**
     * 模板名称
     */
    @ApiModelProperty("模板名称")
    private String templateName;
    /**
     * 适用项目类型
     */
    @ApiModelProperty("适用项目类型")
    private String suitProjectType;
    @ApiModelProperty("适用项目类型")
    private String suitProjectTypeDesc;
    /**
     * 适用BU类型
     */
    @ApiModelProperty("适用BU类型")
    private String tmplType;
    @ApiModelProperty("适用BU类型")
    private String tmplTypeDesc;

    /**
     * 科目模板
     */
    @ApiModelProperty("科目模板")
    private Long subjectTemplateId;
    @ApiModelProperty("科目模板")
    private String subjectTemplateDesc;

    /**
     * 状态
     */
    @ApiModelProperty("是否启用  0:禁用，1：启用")
    private Integer templateStatus;
    @ApiModelProperty("是否启用")
    private String templateStatusName;

    @ApiModelProperty("资源规划周期: WEEK周 MONTH月")
    private String resourcePlanningCycle;

    @ApiModelProperty("活动列表")
    private List<PmsProjectTemplateActVO> actList;


    /**
     * 适用bu
     */
    @ApiModelProperty("适用bu")
    private String baseBu;

    /**
     * 适用buId
     */
    @ApiModelProperty("适用buId")
    private Long baseBuId;

}
