package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchaseAgreementResPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementResQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchaseAgreementResVO;

import java.util.List;

/**
 * 采购协议关联资源
 *
 * @author lemon
 * @date 2023-11-02
 */
public interface PurchaseAgreementResService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link PurchaseAgreementResVO}>
     */
    PagingVO<PurchaseAgreementResVO> queryPaging(PurchaseAgreementResQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link PurchaseAgreementResVO}>
     */
    List<PurchaseAgreementResVO> queryListDynamic(PurchaseAgreementResQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link PurchaseAgreementResVO}
     */
    PurchaseAgreementResVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PurchaseAgreementResVO}
     */
    PurchaseAgreementResVO insert(PurchaseAgreementResPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PurchaseAgreementResVO}
     */
    PurchaseAgreementResVO update(PurchaseAgreementResPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(PurchaseAgreementResPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 删除协议关联资源
     * @param documentIdList 协议IdList
     */
    void deleteSoftByDocumentIdList(List<Long> documentIdList);
}
