package com.elitesland.tw.tw5.api.prd.salecon.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingMonthVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingTypeVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.util.List;

/**
 * ConInvSettingController
 *
 * @author zoey
 * @date 2024-03-14
 */
@Getter
@Setter
public class ConInvSettingPayload extends TwCommonPayload  implements Serializable {
    /** 开票年度 */
    @ApiModelProperty("开票年度")
    private Integer invYear;
    /** 开票主体 */
    @ApiModelProperty("开票主体")
    private Long invOuId;
    /** 状态:1 有效；0 无效 */
    @ApiModelProperty("状态:1 有效；0 无效")
    private Integer effective;
    /** 月最后开票日 */
    @ApiModelProperty("月最后开票日")
    private Integer deadline;

    /**
     * 删除月度设置列表
     */
    private List<Long> deleteSettingMonthKeys;

    /**
     * 删除类型设置列表
     */
    private List<Long> deleteSettingTypeKeys;

    /** 开票月份配置数据 */
    @ApiModelProperty("月最后开票日")
    List<ConInvSettingMonthPayload> conInvSettingMonthPayloadList;

    /** 开票类型配置数据 */
    @ApiModelProperty("月最后开票日")
    List<ConInvSettingTypePayload> conInvSettingTypePayloadList;
}
