package com.elitesland.tw.tw5.api.prd.task.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 任务结算工时关系表
 *
 * @author carl
 * @date 2023-12-20
 */
@Getter
@Setter
public class TaskSettleTimesheetQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 任务id 精确
     */
    @ApiModelProperty("任务id")
    private Long taskId;
    /**
     * 任务id 精确
     */
    @ApiModelProperty("任务id")
    private List<Long> taskIds;
    /**
     * 结算id 精确
     */
    @ApiModelProperty("结算id")
    private Long settleId;
    /**
     * 结算id 精确
     */
    @ApiModelProperty("结算id")
    private List<Long> settleIds;
    /**
     * 工时id 精确
     */
    @ApiModelProperty("工时id")
    private Long timesheetId;
    /**
     * 工时 精确
     */
    @ApiModelProperty("工时")
    private BigDecimal workHour;
    /**
     * 当量 精确
     */
    @ApiModelProperty("当量")
    private BigDecimal eqva;
    /**
     * 工作日期 精确
     */
    @ApiModelProperty("工作日期")
    private LocalDate workDate;
    /**
     * 工作日志 模糊
     */
    @ApiModelProperty("工作日志")
    private String workDesc;
    /**
     * 结算标记（0：否，1：是） 精确
     */
    @ApiModelProperty("结算标记（0：否，1：是）")
    private Integer settleFlag;
}
