package com.elitesland.tw.tw5.api.prd.ts.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 工时审批资源管理
 *
 * @author carl
 * @date 2024-05-04
 */
@Getter
@Setter
public class TsApprovalResPayload extends TwCommonPayload implements Serializable {
    /**
     * 工时id
     */
    @ApiModelProperty("工时id")
    private Long timesheetId;
    /**
     * 配置类型
     */
    @ApiModelProperty("配置类型")
    private String configType;
    /**
     * 配置id
     */
    @ApiModelProperty("配置id")
    private Long configId;
    /**
     * 审批资源id
     */
    @ApiModelProperty("审批资源id")
    private Long approvalResId;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String approvalStatus;
    /**
     * 审批资源描述(项目经理，交付负责人等)
     */
    @ApiModelProperty("审批资源描述(项目经理，交付负责人等)")
    private String approvalSource;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvalTime;
    /**
     * 首次审批时间（前端不用）
     */
    @ApiModelProperty("首次审批时间（前端不用）")
    private LocalDateTime fristApprovalTime;
    /**
     * 排序
     */
    @ApiModelProperty("排序")
    private Integer sortIndex;
    /**
     * 最后审批人
     */
    @ApiModelProperty("最后审批人")
    private Integer lastFlag;
}
