package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 客户经营
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
public class CrmCustomerOperationPayload extends TwCommonPayload {


    /**
     * 客户表主键
     */
    private Long customerId;

    /**
     * 客户经营编号
     */
    private String custNo;

    /**
     * 类型 udc
     */
    private String custType;

    /**
     * 第三方公司主键：天眼查id or 启信宝id
     */
    private String threeId;

    /**
     * 第三方公司类型：天眼查:TYC or 启信宝:QXB
     */
    private String threeType;

    /**
     * 名称
     */
    private String custName;

    /**
     * 公司性质 udc
     */
    private String custNature;

    /**
     * 行业 udc
     */
    private String custIndustry;

    /**
     * 母公司主键
     */
    private Long parentId;

    /**
     * 母公司名称
     */
    private String parentCompany;

    /**
     * 网址
     */
    private String website;

    /**
     * 座机
     */
    private String landline;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 省
     */
    private String province;

    /**
     * 省名字
     */
    private String provinceName;

    /**
     * 城市
     */
    private String city;

    /**
     * 城市名字
     */
    private String cityName;

    /**
     * 区
     */
    private String district;

    /**
     * 地区名称
     */
    private String districtName;

    /**
     * 地址
     */
    private String custAddress;

    /**
     * 客户级别 udc
     */
    private String custGrade;

    /**
     * 销售规模
     */
    private BigDecimal saleScale;

    /**
     * 行业地位 udc
     */
    private String industryStand;

    /**
     * 数字化投入力度 udc
     */
    private String digitalInvestment;

    /**
     * 与公司紧密度 udc
     */
    private String companyTightness;

    /**
     * 历史合作产出（万元）
     */
    private BigDecimal historyCooOutput;

    /**
     * 销售经营部门
     */
    private Long saleOperBu;

    /**
     * 销售经营部负责人
     */
    private Long saleOperManagerId;

    /**
     * 客户经营部门
     */
    private Long custOperBu;

    /**
     * 客户经营部负责人
     */
    private Long custOperManagerId;

    /**
     * 经营策略 udc
     */
    private String businessStrategy;

    /**
     * 主营业务 udc[crm:cust_oper:main_business]
     */
    private String mainBusiness;

    /**
     * 销售覆盖
     */
    private String saleCover;

    /**
     * 合作形式 udc[crm:cust_oper:coop_type]
     */
    private String coopType;

    /**
     * 合作等级
     */
    private String coopLevel;

    /**
     * 渠道经营部门
     */
    private Long channelBu;

    /**
     * 渠道经营负责人
     */
    private Long channelUserId;

    /**
     * 产品负责人
     */
    private Long productUserId;

    /**
     * 生态伙伴业务简述
     */
    private String ecoDescription;

    /**
     * 客户企业 业务简述
     */
    private String custDescription;

    /**
     * 组织及协会简述
     */
    private String orgAssDescription;

    /**
     * 服务负责人
     */
    private Long serviceUserId;

    /**
     * 商务负责人
     */
    private Long businessUserId;

    /**
     * 关怀负责人
     */
    private Long careUserId;

    /**
     * 运维售后负责人
     */
    private Long operationUserId;

    /**
     * 企业logo 启信宝返回
     */
    private String ext1;

    /**
     * 拓展2
     */
    private String ext2;

    /**
     * 拓展3
     */
    private String ext3;

    /**
     * 拓展4
     */
    private String ext4;

    /**
     * 拓展5
     */
    private String ext5;

    /**
     * 提醒时间
     */
    private LocalDateTime noticeTime;

    /**
     * 企业信息-工商照面
     */
    private CrmCustomerOperationEnterpriseInfoPayload enterpriseInfo;

    /**
     * 企业年报信息
     */
    private List<CrmCustomerOperationSitesPayload> sitesList;

    /**
     * 工商股东
     */
    private List<CrmCustomerOperationPartnersPayload> partnersList;

    /**
     * 企业工商主要人员
     */
    private List<CrmCustomerOperationEmployeesPayload> employeesList;

}
