package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class ResSearchVO extends BaseViewModel {

    @ApiModelProperty("userId")
    private Long userId;

    @ApiModelProperty("用户电话")
    private String mobile;

    @ApiModelProperty("用户邮箱")
    private String email;

    @ApiModelProperty("员工编号")
    private String employeeNo;

    @ApiModelProperty("资源编号")
    private String resNo;

    @ApiModelProperty("员工名称")
    private String employeeName;

    @ApiModelProperty("资源状态")
    private String resourceStatus;

    @ApiModelProperty("资源状态名称")
    @UdcName(udcName = "org:employee:resource", codePropName = "resourceStatus")
    private String resourceName;

    @ApiModelProperty("外文名")
    private String foreignName;

    @ApiModelProperty("默认组织id")
    private Long orgId;

    @ApiModelProperty("默认组织名称")
    @UdcName(udcName = "BU", codePropName = "orgId")
    private String orgName;

    @ApiModelProperty("主服务地址")
    private String extString5;
    @UdcName(udcName = "COM.CITY", codePropName = "extString5")
    private String baseCityName;

    @ApiModelProperty("当量系数")
    private BigDecimal eqvaRatio;

    @ApiModelProperty("复合能力")
    private String capsetLevelName;

    @ApiModelProperty("项目履历-名称")
    private String projNames;

    @ApiModelProperty("项目履历-产品")
    private String projProducts;

    @ApiModelProperty("项目履历-其他")
    private String projOther;

    @ApiModelProperty("工作经历-行业")
    private String workIndustrys;

    @ApiModelProperty("工作经历-公司")
    private String workCompanys;

    @ApiModelProperty("工作经历-职位")
    private String workJobs;

}
