package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
 * 资金划款
 *
 * @author wangluyu
 * @date 2024-02-27
 */
@Getter
@Setter
public class TMoneyTransferPayload extends TwCommonPayload implements Serializable {
    /**
     * 编号
     */
    @ApiModelProperty("编号")
    private String transferNo;
    /**
     * 申请人
     */
    @ApiModelProperty("申请人")
    private Long applicantUserId;
    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDate applicantTime;
    /**
     * 申请人所属bu
     */
    @ApiModelProperty("申请人所属bu")
    private Long applicantBuId;
    /**
     * 划款公司
     */
    @ApiModelProperty("划款公司")
    private String transferCompany;
    /**
     * 划款公司bookid
     */
    @ApiModelProperty("划款公司bookid")
    private Long transferCompanyBookId;
    /**
     * 划款账号
     */
    @ApiModelProperty("划款账号")
    private String transferAccount;
    private String transferAccountDesc;
    /**
     * 收款公司
     */
    @ApiModelProperty("收款公司")
    private String collectionCompany;
    /**
     * 收款公司bookid
     */
    @ApiModelProperty("收款公司bookid")
    private Long collectionCompanyBookId;
    /**
     * 收款账号
     */
    @ApiModelProperty("收款账号")
    private String collectionAccount;
    private String collectionAccountDesc;

    /**
     * 划款金额
     */
    @ApiModelProperty("划款金额")
    private BigDecimal transferMoney;
    /**
     * 支付方式 udc[ADMINISTRATION:COST:ACC_PAY_WAY]
     */
    @ApiModelProperty("支付方式 udc[ADMINISTRATION:COST:ACC_PAY_WAY]")
    private String payWay;
    /**
     * 划款说明
     */
    @ApiModelProperty("划款说明")
    private String transferNote;
    /**
     * 划款状态 udc[ADMINISTRATION:COST:ACC_TRANSFER_STATUS]
     */
    @ApiModelProperty("划款状态 udc[ADMINISTRATION:COST:ACC_TRANSFER_STATUS]")
    private String transferStatus;
    /**
     * 附件
     */
    @ApiModelProperty("附件")
    private String fileCodes;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;


    /**
     * 支付方式：1.网银支付 2.手动支付
     */
    @ApiModelProperty("支付方式：1.网银支付 2.手动支付")
    private Integer payMode;


    /**
     * 支付状态：S 成功、F 失败、C撤销、D 过期、R 否决 G退票
     */
    @ApiModelProperty("支付状态：S 成功、F 失败、C撤销、D 过期、R 否决 G退票")
    private String payStatus;


    /**
     * 支付时间
     */
    @ApiModelProperty("支付时间")
    private LocalDateTime payTime;


    /**
     * 网银提交标识 1.已提交 2.未提交
     */
    @ApiModelProperty("网银提交标识 1.已提交 2.未提交")
    private Integer bankFlag;

    /**
     * 网银提交时间
     */
    @ApiModelProperty("网银提交时间")
    private LocalDateTime bankTime;

    /**
     * 支付用途
     */
    @ApiModelProperty("支付用途")
    private String payPurpose;


    /**
     * 内部往来凭证
     */
    @ApiModelProperty("内部往来凭证")
    private String jdeDocNo;


    /**
     * 内部往来凭证2
     */
    @ApiModelProperty("内部往来凭证2")
    private String jdeDocNo2;


    /**
     * 内部往来凭证失败原因
     */
    @ApiModelProperty("内部往来凭证失败原因")
    private String jdeErrMsg;


    /**
     * 摘要
     */
    @ApiModelProperty("摘要")
    private String jdeSummary;

    /**
     * 凭证日期
     */
    @ApiModelProperty("凭证日期")
    private String jdeDocTime;

    /**
     * JDE凭证状态(成功、失败)
     */
    @ApiModelProperty("JDE凭证状态")
    private String jdeDocState;

    /**
     * 网银失败原因
     */
    @ApiModelProperty("网银失败原因")
    private String bankErrmsg;
}
