package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TServerApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TServerApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.TServerApplyVO;

import java.util.List;

/**
 * 服务器申请
 *
 * @author lemon
 * @date 2023-09-23
 */
public interface TServerApplyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TServerApplyVO}>
     */
    PagingVO<TServerApplyVO> queryPaging(TServerApplyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TServerApplyVO}>
     */
    List<TServerApplyVO> queryListDynamic(TServerApplyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TServerApplyVO}
     */
    TServerApplyVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TServerApplyVO}
     */
    TServerApplyVO insert(TServerApplyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TServerApplyVO}
     */
    TServerApplyVO update(TServerApplyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TServerApplyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
