package com.elitesland.tw.tw5.api.prd.my.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;


/**
 * 假期取消申请
 *
 * @author carl
 * @date 2024-06-18
 */
@Getter
@Setter
public class TUserVacationCancelVO extends BaseViewModel implements Serializable {
    /**
     * 用户id
     */
    @ApiModelProperty("用户id")
    private Long userId;
    @UdcName(udcName = "USER", codePropName = "userId")
    private String userName;
    /**
     * 直属领导id
     */
    @ApiModelProperty("直属领导id")
    private Long pUserId;
    @UdcName(udcName = "USER", codePropName = "pUserId")
    private String pUserName;
    /**
     * 部门id
     */
    @ApiModelProperty("部门id")
    private Long orgId;
    @UdcName(udcName = "BU", codePropName = "orgId")
    private String orgName;
    /**
     * 请假id
     */
    @ApiModelProperty("请假id")
    private Long applyId;
    /**
     * 公司id
     */
    @ApiModelProperty("公司id")
    private Long companyId;
    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String companyName;
    /**
     * 请假单号
     */
    @ApiModelProperty("请假单号")
    private String applyNo;
    /**
     * 操作类型
     */
    @ApiModelProperty("操作类型")
    private String operType;
    /**
     * 修改说明
     */
    @ApiModelProperty("修改说明")
    private String cancelDesc;
    /**
     * 操作日期
     */
    @ApiModelProperty("操作日期")
    private LocalDate cancelDate;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String procInstStatus;
    @UdcName(udcName = "appr_status", codePropName = "procInstStatus")
    private String procInstStatusDesc;
    /**
     * 流程id
     */
    @ApiModelProperty("流程id")
    private String procInstId;

    @ApiModelProperty("请假数据")
    private UserVacationApplyVO userVacationApplyVO;

    /**
     * 请假开始日
     */
    private LocalDate startDate;
    /**
     * 请假结束日
     */
    private LocalDate endDate;
    /**
     * 请假天数
     */
    private BigDecimal vacationDays;
}
