package com.elitesland.tw.tw5.api.prd.org.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

@Data
public class PrdOrgEmployeeDataPayload extends TwCommonPayload {


    @ApiModelProperty("用户账号")
    private String userName;

    @ApiModelProperty("用户姓氏")
    private String lastName;

    @ApiModelProperty("用户名称")
    private String firstName;

    @ApiModelProperty("用户电话")
    private String mobile;

    @ApiModelProperty("用户邮箱")
    private String email;

    @ApiModelProperty("账户状态")
    private Boolean enabled;

    @ApiModelProperty("自然人ID")
    private Long personId;

    @ApiModelProperty("系统用户ID")
    private Long userId;

    @ApiModelProperty("公司ID")
    private Long companyId;

    @ApiModelProperty("公司名称")
    private String companyName;


    @ApiModelProperty("员工编号")
    private String employeeNo;

    @ApiModelProperty("员工名称")
    private String employeeName;

    @ApiModelProperty("资源状态")
    private String resourceStatus;

    @ApiModelProperty("资源状态名称")
    private String resourceName;

    @ApiModelProperty("人事状态")
    private String hrStatus;//0：有效，1：无效

    @ApiModelProperty("人事状态名称")
    private String hrName;


    @ApiModelProperty("入职日期")
    private LocalDate enrollDate;

    @ApiModelProperty("安全级别")
    private Integer accessLevel;

    @ApiModelProperty("岗位")
    private String jobs;

    @ApiModelProperty("岗位名称")
    private String jobsName;

    @ApiModelProperty("排序")
    private Integer sortIndex;


    @ApiModelProperty("外文名")
    private String foreignName;

    @ApiModelProperty("证件类型")
    private String idType;

    @ApiModelProperty("证件类型名称")
    private String idTypeName;

    @ApiModelProperty("证件号码")
    private String idNo;

    @ApiModelProperty("证件开始日")
    private LocalDate idValidFrom;

    @ApiModelProperty("证件到期日")
    private LocalDate idValidTo;

    @ApiModelProperty("证件url")
    private String idValidUrl;

    @ApiModelProperty("生日")
    private LocalDate birthday;

    @ApiModelProperty("性别")
    private String sex;
    @ApiModelProperty("性别名称")
    private String sexName;

    @ApiModelProperty("国籍")
    private String nationality;

    @ApiModelProperty("籍贯")
    private String birthplace;

    @ApiModelProperty("民族")
    private String nation;

    @ApiModelProperty("婚姻状况")
    private Integer marital;

    @ApiModelProperty("通讯地址")
    private String addr;

    @ApiModelProperty("紧急联系人")
    private String urgency_name;

    @ApiModelProperty("手机号")
    private String urgency_mobile;

    @ApiModelProperty("关系")
    private String urgency_ref;

    @ApiModelProperty("默认组织id")
    private Long orgId;

    @ApiModelProperty("默认组织名称")
    private String orgName;

    @ApiModelProperty("上级ID")
    private Long parentId;


    /**
     * 上级员工编号
     */
    @ApiModelProperty("上级员工编号")
    private String parentEmployeeNo;
    /**
     * 上级员工名称
     */
    @ApiModelProperty("上级员工名称")
    private String parentEmployeeName;
    /**
     * 专业级别
     */
    private String extString1;
    /**
     * 管理级别
     */
    private String extString2;
    /**
     * 专业序列
     */
    private String extString3;
    /**
     * 职位序列
     */
    private String extString4;
    /**
     * 主服务地址
     */
    private String extString5;
    /**
     * 内部类型
     */
    private String extString6;
    /**
     * 话费额度
     */
    private String extString7;
    /**
     * 电脑额度
     */
    private String extString8;
    private String extString9;
    private String extString10;
    private String extString11;
    private String extString12;
    /**
     * 离职日期
     */
    private LocalDate extDate1;
    /**
     * 转正日期
     */
    private LocalDate extDate2;
    /**
     * 合同签订日期
     */
    private LocalDate extDate3;
    /**
     * 合同到期日
     */
    private LocalDate extDate4;
    /**
     * 实习入职日期
     */
    private LocalDate extDate5;
    /**
     * 试用期开始
     */
    private LocalDate extDate6;
    /**
     * 试用期结束
     */
    private LocalDate extDate7;
    private LocalDate extDate8;
}
