package com.elitesland.tw.tw5.api.prd.partner.common.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 业务伙伴管理
 *
 * @author wangluyu
 * @date 2023-05-16
 */
@Getter
@Setter
public class BusinessPartnerPayload extends TwCommonPayload implements Serializable {
    /**
     * 地址簿id 用来和银行账户 基本信息 地址信息等关联
     */
    @ApiModelProperty("地址簿id 用来和银行账户 基本信息 地址信息等关联")
    private Long bookId;
    /**
     * 业务伙伴编号
     */
    @ApiModelProperty("业务伙伴编号")
    private String businessPartnerNo;
    /**
     * 类型 udc[CRM:BUSINESS_PARTNER:TYPE]
     */
    @ApiModelProperty("类型 udc[CRM:BUSINESS_PARTNER:TYPE]")
    private String partnerType;
    /**
     * 业务伙伴名称
     */
    @ApiModelProperty("业务伙伴名称")
    private String partnerName;
    /**
     * 业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]
     */
    @ApiModelProperty("业务伙伴身份 udc[CRM:BUSINESS_PARTNER:IDENTITY]")
    private String partnerIdentity;
    /**
     * 行业 udc[crm:leads_customer_industry]
     */
    @ApiModelProperty("行业 udc[crm:leads_customer_industry]")
    private String partnerIndustry;
    /**
     * 性质 udc[crm:company_nature]
     */
    @ApiModelProperty("性质 udc[crm:company_nature]")
    private String partnerNature;
    /**
     * 组织规模 udc[crm:customer_scale]
     */
    @ApiModelProperty("组织规模 udc[crm:customer_scale]")
    private String organizationScale;
    /**
     * 网址
     */
    @ApiModelProperty("网址")
    private String partnerWebsite;
    /**
     * 邮箱
     */
    @ApiModelProperty("邮箱")
    private String partnerEmail;
    /**
     * 传真
     */
    @ApiModelProperty("传真")
    private String partnerFax;
    /**
     * 电话
     */
    @ApiModelProperty("电话")
    private String partnerPhone;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String partnerRegion;
    /**
     * 主交易货币  udc[SYSTEM_BASIC:CURRENCY]
     */
    @ApiModelProperty("主交易货币  udc[SYSTEM_BASIC:CURRENCY]")
    private String currency;
    /**
     * 主要语言
     */
    @ApiModelProperty("主要语言")
    private String language;

    /****个人类型  起****/

    /**
     * 英文名称
     */
    @ApiModelProperty("英文名称")
    private String englishName;

    /**
     * 证件类型
     */
    @ApiModelProperty("个人证件类型 udc[CRM:BUSINESS_PARTNER:CERTIFICATE_TYPE]")
    private String certificateType;

    /**
     * 证件号
     */
    @ApiModelProperty("证件号")
    private String certificateNo;

    /**
     * 性别 udc[org:employee:sex]
     */
    @ApiModelProperty("性别 udc[org:employee:sex]")
    private String partnerSex;

    /**
     * 生日
     */
    @ApiModelProperty("生日")
    private String partnerBirthday;

    /**
     * 国籍
     */
    @ApiModelProperty("国籍 udc[SYSTEM_BASIC:COUNTRY]")
    private String nationality;

    /**
     * 籍贯
     */
    @ApiModelProperty("籍贯")
    private String nativePlace;

    /**
     * 民族
     */
    @ApiModelProperty("民族")
    private String nation;

    /**
     * 婚姻状况
     */
    @ApiModelProperty("婚姻状况 udc[CRM:BUSINESS_PARTNER:MARITAL_STATUS]")
    private String maritalStatus;

    /**
     * 证件有效期
     */
    @ApiModelProperty("证件有效期起")
    private LocalDate certificateDateStart;

    /**
     * 证件有效期
     */
    @ApiModelProperty("证件有效期止")
    private LocalDate certificateDateEnd;

    /****个人类型  止****/

//
//    /** 手机 */
//    @ApiModelProperty("手机")
//    private String partnerTelephone;
//    /** 微信 */
//    @ApiModelProperty("微信")
//    private String partnerWeChat;

    /**
     * 排序号
     */
    @ApiModelProperty("排序号")
    private Integer sortNo;
    /**
     * 拓展字段1
     */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /**
     * 拓展字段2
     */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /**
     * 拓展字段3
     */
    @ApiModelProperty("拓展字段3")
    private String ext3;
    /**
     * 拓展字段4
     */
    @ApiModelProperty("拓展字段4")
    private String ext4;
    /**
     * 拓展字段5
     */
    @ApiModelProperty("拓展字段5")
    private String ext5;
    /**
     * 母公司ID
     */
    @ApiModelProperty("母公司ID")
    private Long parentId;

    /**
     * 国家
     */
    @ApiModelProperty("国家")
    private String country;
    /**
     * 省
     */
    @ApiModelProperty("省")
    private String province;
    /**
     * 市
     */
    @ApiModelProperty("市")
    private String city;
    /**
     * 区
     */
    @ApiModelProperty("区")
    private String district;
    /**
     * 省
     */
    @ApiModelProperty("省")
    private String provinceName;
    /**
     * 市
     */
    @ApiModelProperty("市")
    private String cityName;
    /**
     * 区
     */
    @ApiModelProperty("区")
    private String districtName;
    /**
     * 详细地址
     */
    @ApiModelProperty("详细地址")
    private String detailAddress;
    /**
     * 联系人姓名
     */
    @ApiModelProperty("联系人姓名")
    private String contactsName;
    /**
     * 联系人手机
     */
    @ApiModelProperty("联系人手机")
    private String contactsPhone;
    /**
     * 是否有客户身份
     */
    @ApiModelProperty("是否有客户身份")
    private Boolean customerFlag;
    /**
     * 客户级别
     */
    @ApiModelProperty("客户级别")
    private String customerGradle;
    /**
     * 客户来源
     */
    @ApiModelProperty("客户来源")
    private String customerSource;
    /**
     * 客户状态
     */
    @ApiModelProperty("客户状态")
    private String customerStatus;
    /**
     * 客户区域
     */
    @ApiModelProperty("客户区域")
    private String customerRegion;

    /**
     * 部门
     */
    @ApiModelProperty("部门")
    private String contactsDepartment;
    /**
     * 岗位
     */
    @ApiModelProperty("岗位")
    private String contactsPosition;

    /**
     * 经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标
     */
    @ApiModelProperty("经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标")
    private String longitudeLatitude;

    /**
     * 服务负责人
     */
    @ApiModelProperty("服务负责人")
    private Long serviceUserId;

    /**
     * 商务负责人
     */
    @ApiModelProperty("商务负责人")
    private Long businessUserId;

    /**
     * 关怀负责人
     */
    @ApiModelProperty("关怀负责人")
    private Long careUserId;

    /**
     * 运维售后负责人
     */
    @ApiModelProperty("运维售后负责人")
    private Long operationUserId;


    /**
     * 第三方系统编号
     */
    @ApiModelProperty("JDE编号")
    private String thirdSystemNo;

    //供应商信息
    /** 是否有供应商身份  */
    @ApiModelProperty("是否有供应商身份")
    private Boolean supplierFlag;
    /**
     * 供应商级别 udc[crm:customer_grade]
     */
    @ApiModelProperty("供应商级别 udc[crm:customer_grade]")
    private String supplierGradle;

    /**
     * 采购负责人
     */
    @ApiModelProperty("采购负责人")
    private Long purchaseInchargeResId;

    /**
     * 供货开始时间
     */
    @ApiModelProperty("供货开始时间")
    private LocalDate startTime;

    /**
     * 供货结束时间
     */
    @ApiModelProperty("供货结束时间")
    private LocalDate endTime;

    /**
     * 结算周期
     */
    @ApiModelProperty("结算周期")
    private String settlementPeriod;

    /**
     * 资质审核资料附件
     */
    @ApiModelProperty("资质审核资料附件")
    private String fileCode1;

    /**
     * 实地考察资料 附件
     */
    @ApiModelProperty("实地考察资料")
    private String fileCode2;

    //合作伙伴

    /**
     * 合作级别 udc[crm:customer_grade]
     */
    @ApiModelProperty("合作级别 udc[crm:customer_grade]")
    private String collaborateGradle;

    /**
     * 合作形式
     */
    @ApiModelProperty("合作形式")
    private String collaborateForm;

    /**
     * 合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE] 精确
     */
    @ApiModelProperty("合作类别 udc[CRM:BUSINESS_PARTNER:COLLABORATE_TYPE]")
    private String collaborateType;

    /**
     * 合作产品/服务
     */
    @ApiModelProperty("合作产品/服务")
    private String collaborateProduct;

    /**
     * 伙伴服务行业 精确
     */
    @ApiModelProperty("伙伴服务行业")
    private String collaborateServiceIndustry;

    /**
     * 服务典型客户 精确
     */
    @ApiModelProperty("服务典型客户")
    private String collaborateCustomer;

    /**
     * 服务客户规模 精确
     */
    @ApiModelProperty("服务客户规模")
    private String serviceCustomerScale;

    /**
     * 合作区域 udc[crm:customer_region] 精确
     */
    @ApiModelProperty("合作区域 udc[crm:customer_region]")
    private String collaborateRegion;


    /**
     * 对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE] 精确
     */
    @ApiModelProperty("对接人类型 udc[CRM:BUSINESS_PARTNER:CONTACT_TYPE]")
    private String contactPeopleType;

    /**
     * 渠道负责人 精确
     */
    @ApiModelProperty("渠道负责人")
    private Long channelUserId;

    /**
     * 我司负责人bu 精确
     */
    @ApiModelProperty("我司负责人bu")
    private Long buManageUserId;

    /**
     * 我司负责人电话 精确
     */
    @ApiModelProperty("我司负责人电话")
    private String buManagePhone;

    /**
     * 我司负责人邮箱 精确
     */
    @ApiModelProperty("我司负责人邮箱")
    private String buManageEmail;

    /**
     * 合作开始时间
     */
    @ApiModelProperty("合作开始时间")
    private LocalDate collaborateStartTime;

    /**
     * 合作结束时间
     */
    @ApiModelProperty("合作结束时间")
    private LocalDate collaborateEndTime;

    /**
     * 合作期间说明
     */
    @ApiModelProperty("合作期间说明")
    private String collaborateDescription;

    /**
     * 合作伙伴标签
     */
    @ApiModelProperty("合作伙伴标签")
    private String collaborateTag;

    /** 是否有合作伙伴身份  */
    @ApiModelProperty("是否有合作伙伴身份")
    private Boolean collaborateFlag;
    /**
     * 合作伙伴关键词 精确
     */
    @ApiModelProperty("合作伙伴关键词")
    private String collaborateKeyword;

    /**
     * 公司介绍附件
     */
    @ApiModelProperty("公司介绍附件")
    private String fileCode3;

    /**
     * 合作协议附件
     */
    @ApiModelProperty("合作协议附件")
    private String fileCode4;

    /**
     * 产品介绍附件
     */
    @ApiModelProperty("产品介绍附件")
    private String fileCode5;

    //流程字段
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("流程提交标志")
    private Boolean submit;

    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String applyStatus;

    /**
     * 内部/外部
     */
    @ApiModelProperty("内部/外部 udc[CRM:BUSINESS_PARTNER:INSIDE_OR_OUTSIDE]")
    private String insideOrOutSide;

    /**
     * 4.0地址簿id
     */
    @ApiModelProperty("4.0地址簿id")
    private Long bookIdV4;

    /**
     *  同步启信宝标志
     */
    @ApiModelProperty("同步启信宝标志")
    private Boolean qxbDataInitFlag;

    @ApiModelProperty("上级主管部门")
    private String parentManageBu;
}
