package com.elitesland.tw.tw5.api.prd.personplan.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;


/**
 * @author : WWW
 * @date : 2024-2-21
 * @desc : 人员规划
 */
@Data
@ApiModel(description = "人员规划")
public class PersonPlanQuery extends TwQueryParam {

    /**
     * 主键ids
     */
    @ApiModelProperty("主键ids")
    private List<Long> ids;

    /**
     * 关联对象ID
     */
    @ApiModelProperty("关联对象ID")
    private Long objId;

    /**
     * 关联对象
     */
    @ApiModelProperty("关联对象")
    private String objName;

    /**
     * 计划类型
     */
    @ApiModelProperty("计划类型")
    private String planType;
    /**
     * 状态
     */
    @ApiModelProperty("状态")
    private Integer state;

    /**
     * 开始日期
     */
    @ApiModelProperty("开始日期")
    private LocalDate startDate;

    /**
     * 结束日期
     */
    @ApiModelProperty("结束日期")
    private LocalDate endDate;

    /**
     * 持续时长
     */
    @ApiModelProperty("持续时长")
    private Integer duration;

    /**
     * 周期单位
     */
    @ApiModelProperty("周期单位")
    private String uom;

    /**
     * 当前版本
     */
    @ApiModelProperty("当前版本")
    private String version;


}

