package com.elitesland.tw.tw5.api.prd.pms.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 派发响应
 *
 * @author xxb
 * @date 2023-10-08
 */
@Getter
@Setter
public class PmsDistributeRespondPayload extends TwCommonPayload  implements Serializable {
    /** 派发ID */
    @ApiModelProperty("派发ID")
    private Long distId;
    /** 派发对象 */
    @ApiModelProperty("派发对象")
    private String reasonName;
    /** 派发人 */
    @ApiModelProperty("派发人")
    private Long disterResId;
    /** 响应状态 */
    @ApiModelProperty("响应状态")
    private String respStatus;
    /** 响应时间 */
    @ApiModelProperty("响应时间")
    private LocalDateTime respTime;
    /** 响应描述 */
    @ApiModelProperty("响应描述")
    private String respDesc;
    /** 是否邀请 */
    @ApiModelProperty("是否邀请")
    private Integer inviteFlag;
    /** 响应资源ID */
    @ApiModelProperty("响应资源ID")
    private Long respondentResId;
}
