package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 项目模板
 *
 * @author xxb
 * @date 2023-08-02
 */
@Getter
@Setter
public class PmsProjectTemplateQuery extends TwQueryParam implements Serializable {
    /**
     * 模板名称 模糊
     */
    @ApiModelProperty("模板名称")
    @Query
    private String templateName;
    /**
     * 适用项目类型  精确
     */
    @ApiModelProperty("适用项目类型")
    @Query
    private String suitProjectType;
    /**
     * 适用BU类型
     */
    @ApiModelProperty("适用BU类型")
    private String tmplType;
    /**
     * 是否启用  精确
     */
    @ApiModelProperty("是否启用  0:禁用，1：启用")
    @Query
    private Integer templateStatus;

    @ApiModelProperty("资源规划周期: WEEK周 MONTH月")
    @Query
    private String resourcePlanningCycle;

    /**
     * 适用bu
     */
    @ApiModelProperty("适用bu")
    private String baseBu;

    /**
     * 适用buId
     */
    @ApiModelProperty("适用buId")
    private Long baseBuId;
}
