package com.elitesland.tw.tw5.api.prd.pms.vo;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;


/**
 * 项目汇报管理
 *
 * @author carl
 * @date 2023-09-05
 */
@Getter
@Setter
@SearchBean(
        tables = "pms_project_brief pb " +
                "left join pms_project pp on pp.id = pb.proj_id " +
                "left join sale_con_contract scc on pp.contract_id = scc.id ",
        where = "pb.delete_flag =0 and pp.delete_flag = 0 and scc.delete_flag = 0",
        autoMapTo = "pb"
)
public class PmsProjectBriefVO extends BaseViewModel implements Serializable {
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId = 0L;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projId;

    // -----合同表 -----strat-----

    /**
     * 参考合同号
     */
    @ApiModelProperty("参考合同号")
    @DbField(mapTo = "scc")
    private String referCode;

    /**
     * 合同状态
     */
    @ApiModelProperty("合同状态")
    @DbField(mapTo = "scc", value = "status")
    private String contractStatus;
    @ExcelProperty(index = 2, value = "合同状态")
    @UdcName(udcName = "salecon:status", codePropName = "contractStatus")
    @DbIgnore
    private String contractStatusDesc;

    /**
     * （合同测）项目交付负责人
     */
    @ApiModelProperty("项目交付负责人")
    @DbField(mapTo = "scc")
    private Long deliUserId;

    // @UdcName(udcName = "USER", codePropName = "deliUserId")
    // @DbIgnore
    // private String deliUserName;

    /**
     * 签单BU_ID
     */
    @ApiModelProperty("签单BU_ID")
    @DbField(mapTo = "scc")
    private Long signBuId;
    @UdcName(udcName = "BU", codePropName = "signBuId")
    @DbIgnore
    private String signBuName;

    /**
     * 工作类型
     */
    @DbField(mapTo = "scc")
    private String workType;

    // -----合同表 -----end-----


    // ----- 项目表   ------start----

    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    @DbField(mapTo = "pp")
    private String projName;
    /**
     * 项目编号
     */
    @ApiModelProperty("项目编号")
    @DbField(mapTo = "pp")
    private String projNo;
    /**
     * 交付BU_ID
     */
    @ApiModelProperty("交付BU")
    @DbField(mapTo = "pp")
    private Long deliBuId;
    @UdcName(udcName = "BU", codePropName = "deliBuId")
    @DbIgnore
    private String deliBuName;

    /**
     * 项目pmo资源负责人id
     */
    @ApiModelProperty("项目PMO")
    @DbField(mapTo = "pp")
    private Long pmoResId;

    // @DbIgnore
    // @UdcName(udcName = "USER", codePropName = "pmoResId")
    // private String pmoResName;
    /**
     * 督导资源id
     */
    @ApiModelProperty("督导")
    @DbField(mapTo = "pp")
    private Long superResId;

    // @DbIgnore
    // @UdcName(udcName = "USER", codePropName = "superResId")
    // private String superResName;

    /**
     * 项目经理资源id
     */
    @ApiModelProperty("项目经理")
    @DbField(mapTo = "pp")
    private Long pmResId;

    // @DbIgnore
    // @UdcName(udcName = "USER", codePropName = "pmResId")
    // private String pmResName;
    /**
     * 研发补贴金额
     */
    @ApiModelProperty("研发补贴金额")
    @DbField(mapTo = "pp")
    private BigDecimal subsidyAmt;

    // ----- 项目表   ------end----

    /**
     * 项目金额
     */
    @ApiModelProperty("项目金额")
    private BigDecimal projAmt;
    /**
     * 项目金额 税后
     */
    @DbIgnore
    private BigDecimal projAmtNoTax;
    /**
     * 已收款金额
     */
    @ApiModelProperty("已收款金额")
    private BigDecimal recvedAmt;
    /**
     * 未收款金额
     */
    @DbIgnore
    private BigDecimal notReceivedAmt;
    /**
     * 已开票金额
     */
    @ApiModelProperty("已开票金额")
    private BigDecimal invoicedAmt;
    /**
     * 开票未收款金额
     */
    @DbIgnore
    private BigDecimal invoicedNotReceivedAmt;

    /**
     * 未开票应收款金额
     */
    @DbIgnore
    private BigDecimal notInvoicedReceivedAmt;
    /**
     * 实际收款百分比
     */
    @DbIgnore
    private BigDecimal actualReceivedRate;


    //税率
    private BigDecimal taxRate;
    /**
     * 汇报编号
     */
    @ApiModelProperty("汇报编号")
    private String briefNo;

    /**
     * 汇报状态
     */
    @ApiModelProperty("汇报状态")
    private String briefStatus;
    @UdcName(udcName = "PMS:REPORT:STATUS", codePropName = "briefStatus")
    @DbIgnore
    private String briefStatusDesc;
    /**
     * 审批状态
     */
    @ApiModelProperty("审批状态")
    private String apprStatus;
    /**
     * 流程实例ID
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 财务期间id
     */
    @ApiModelProperty("财务期间id")
    private LocalDate finPeriodDate;
    /**
     * 提交日期
     */
    @ApiModelProperty("提交日期")
    private LocalDate applyDate;
    /**
     * 记录创建者 提交资源userid
     */
    @ApiModelProperty("记录创建者")
    private Long applyUserId;
    @UdcName(udcName = "USER", codePropName = "applyUserId")
    @DbIgnore
    private String applyUserDesc;
    /**
     * 费用预算总金额
     */
    @ApiModelProperty("费用预算总金额")
    private BigDecimal feeBudgetAmt;
    /**
     * 费用预算已拨付金额
     */
    @ApiModelProperty("费用预算已拨付金额")
    private BigDecimal feeReleasedAmt;
    /**
     * 费用预算已使用金额
     */
    @ApiModelProperty("费用预算已使用金额")
    private BigDecimal feeUsedAmt;
    /**
     * 当量预算总数
     */
    @ApiModelProperty("当量预算总数")
    private BigDecimal eqvaBudgetCnt;
    /**
     * 当量预算总金额
     */
    @ApiModelProperty("当量预算总金额")
    private BigDecimal eqvaBudgetAmt;
    /**
     * 当量已拨付数量
     */
    @ApiModelProperty("当量已拨付数量")
    private BigDecimal eqvaReleasedQty;
    /**
     * 当量已拨付金额
     */
    @ApiModelProperty("当量已拨付金额")
    private BigDecimal eqvaReleasedAmt;
    /**
     * 当量已派发数量
     */
    @ApiModelProperty("当量已派发数量")
    private BigDecimal eqvaDistedQty;
    /**
     * 当量已派发金额
     */
    @ApiModelProperty("当量已派发金额")
    private BigDecimal eqvaDistedAmt;
    /**
     * 当量已结算数量
     */
    @ApiModelProperty("当量已结算数量")
    private BigDecimal eqvaSettledQty;
    /**
     * 当量已结算金额
     */
    @ApiModelProperty("当量已结算金额")
    private BigDecimal eqvaSettledAmt;
    /**
     * 当量派发百分比
     */
    @ApiModelProperty("当量派发百分比")
    private BigDecimal eqvaDistedPercnet;
    /**
     * 当量结算百分比
     */
    @ApiModelProperty("当量结算百分比")
    private BigDecimal eqvaSettledPercent;
    /**
     * 报告完工百分比
     */
    @ApiModelProperty("报告完工百分比")
    private BigDecimal reprotCompPercent;
    /**
     * 调整完工百分比
     */
    @ApiModelProperty("调整完工百分比")
    private BigDecimal confirmCompPercent;
    /**
     * 财务调整说明
     */
    @ApiModelProperty("财务调整说明")
    private String confirmCompDesc;

    /**
     * 确认收入金额
     */
    @ApiModelProperty("确认收入金额")
    private BigDecimal confirmedAmt;
    /**
     * 当期确认收入
     */
    @ApiModelProperty("当期确认收入")
    private BigDecimal confirmAmt;
    /**
     * 实际确认收入百分比
     */
    @ApiModelProperty("实际确认收入百分比")
    private BigDecimal confirmedPercent;
    /**
     * 申请拨付费用金额
     */
    @ApiModelProperty("申请拨付费用金额")
    private BigDecimal applyFeeAmt;
    /**
     * 申请拨付当量数
     */
    @ApiModelProperty("申请拨付当量数")
    private BigDecimal applyEqvaCnt;
    /**
     * 申请拨付当量金额
     */
    @ApiModelProperty("申请拨付当量金额")
    private BigDecimal applyEqvaAmt;
    /**
     * 实际拨付费用金额
     */
    @ApiModelProperty("实际拨付费用金额")
    private BigDecimal approveFeeAmt;
    /**
     * 实际拨付当量数
     */
    @ApiModelProperty("实际拨付当量数")
    private BigDecimal approveEqvaCnt;
    /**
     * 实际拨付当量金额
     */
    @ApiModelProperty("实际拨付当量金额")
    private BigDecimal approveEqvaAmt;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 进度汇报说明
     */
    @ApiModelProperty("进度汇报说明")
    private String briefDesc;
    /**
     * 费用申请说明
     */
    @ApiModelProperty("费用申请说明")
    private String feeApplyDesc;
    /**
     * 当量申请说明
     */
    @ApiModelProperty("当量申请说明")
    private String eqvaApplyDesc;
    /**
     * 项目进度状态
     */
    @ApiModelProperty("项目进度状态")
    private String projProcessStatus;
    @UdcName(udcName = "PMS:PROCESS:STATUS", codePropName = "projProcessStatus")
    @DbIgnore
    private String projProcessStatusDesc;
    /**
     * 风险描述
     */
    @ApiModelProperty("风险描述")
    private String riskDesc;
    /**
     * 预计还会发生的报销费用
     */

    @ApiModelProperty("预计还会发生的报销费用")
    private BigDecimal predictReimAmt;
    /**
     * 预计还会发生的劳务费用
     */
    @ApiModelProperty("预计还会发生的劳务费用")
    private BigDecimal predictLaborAmt;
    /**
     * 已发生的劳务费用
     */
    @ApiModelProperty("已发生的劳务费用")
    private BigDecimal passedLaborAmt;
    /**
     * 上期数据
     */
    @ApiModelProperty("上期数据")
    @DbIgnore
    private PmsProjectBriefVO lastPeriodBrief;
    /**
     * 自动汇报标识
     */
    @ApiModelProperty("自动汇报标识")
    private Integer autoReportFlag;

    @DbIgnore
    private List<ConReceivablePlanVO> recvPlanViews;
}
