package com.elitesland.tw.tw5.api.prd.purchase.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 付款计划参考
 *
 * @author likunpeng
 * @date 2023-11-22
 */
@Getter
@Setter
public class PaymentPlanReferPayload extends TwCommonPayload  implements Serializable {
    /** 预付款ID（付款申请单表主键） */
    @ApiModelProperty("预付款ID（付款申请单表主键）")
    private Long paymentApplyId;
    /** 预付款编号 */
    @ApiModelProperty("预付款编号")
    private String paymentNo;
    /** 付款阶段 */
    @ApiModelProperty("付款阶段")
    private String paymentStage;
    /** 付款金额（预付款金额） */
    @ApiModelProperty("付款金额（预付款金额）")
    private BigDecimal paymentAmt;
    /** 本次付款金额 */
    @ApiModelProperty("本次付款金额")
    private BigDecimal currentPaymentAmt;
    /** 付款比例 */
    @ApiModelProperty("付款比例")
    private BigDecimal paymentProportion;
    /** 预计付款日期 */
    @ApiModelProperty("预计付款日期")
    private LocalDate estimatedPaymentDate;
    /** 采购合同id */
    @ApiModelProperty("采购合同id")
    private Long contractId;
    /** 采购合同编号 */
    @ApiModelProperty("采购合同编号")
    private String contractNo;
    /** 付款状态 */
    @ApiModelProperty("付款状态")
    private String paymentStatus;
    /** 付款时间 */
    @ApiModelProperty("付款时间")
    private LocalDate paymentDate;
}
