package com.elitesland.tw.tw5.api.prd.purchase.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.ResSetRatePayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.ResSetRateQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.ResSetRateVO;

import java.util.List;

/**
 * 人力资源结算费率
 *
 * @author lemon
 * @date 2023-11-02
 */
public interface ResSetRateService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ResSetRateVO}>
     */
    PagingVO<ResSetRateVO> queryPaging(ResSetRateQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ResSetRateVO}>
     */
    List<ResSetRateVO> queryListDynamic(ResSetRateQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ResSetRateVO}
     */
    ResSetRateVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ResSetRateVO}
     */
    ResSetRateVO insert(ResSetRatePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ResSetRateVO}
     */
    ResSetRateVO update(ResSetRatePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(ResSetRatePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 删除人力资源结算费
     * @param documentIdList 协议IdList
     */
    void deleteSoftByDocumentIdList(List<Long> documentIdList);

    /**
     * 查看人力资源结算费
     * @param agreementId 协议Id
     * @return 人力资源结算费
     */
    List<ResSetRateVO> findByAgreementId(Long agreementId);
}
