package com.elitesland.tw.tw5.api.prd.salecon.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingTypePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConInvSettingTypeQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingTypeVO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * ConInvSettingTypeController
 *
 * @author zoey
 * @date 2024-03-14
 */
public interface ConInvSettingTypeService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConInvSettingTypeVO}>
     */
    PagingVO<ConInvSettingTypeVO> queryPaging(ConInvSettingTypeQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConInvSettingTypeVO}>
     */
    List<ConInvSettingTypeVO> queryListDynamic(ConInvSettingTypeQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConInvSettingTypeVO}
     */
    ConInvSettingTypeVO queryByKey(Long key);

    /**
     * 通过主表id查询
     *
     * @param invSettingId 主表id
     * @return {@link ConInvSettingTypeVO}
     */
    List<ConInvSettingTypeVO> queryByInvSettingId(Long invSettingId);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConInvSettingTypeVO}
     */
    ConInvSettingTypeVO insert(ConInvSettingTypePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConInvSettingTypeVO}
     */
    ConInvSettingTypeVO update(ConInvSettingTypePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(ConInvSettingTypePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);


}
