package com.elitesland.tw.tw5.api.prd.visit.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 销售拜访任务执行情况签到记录
 *
 * @author duwh
 * @date 2023-03-13
 */
@Getter
@Setter
public class VisitSignRecordPayload extends TwCommonPayload  implements Serializable {
    /** 拜访计划主键 */
    @ApiModelProperty("拜访计划主键")
    private Long planId;
    /** 拜访任务主键crm_visit_task.id */
    @ApiModelProperty("拜访任务主键crm_visit_task.id")
    private Long taskId;
    /** 任务名称（冗余）crm_visit_task.task_name */
    @ApiModelProperty("任务名称（冗余）crm_visit_task.task_name")
    private String taskName;
    /**
     * 类型 ( 签到 IN  签退 OUT )
     */
    @ApiModelProperty("类型 ( 签到 IN  签退 OUT )")
    private String type;
    /** 签到坐标（最新） */
    @ApiModelProperty("签到坐标（最新）")
    private String locations;
    /** 签到地点（最新） */
    @ApiModelProperty("签到地点（最新）")
    private String address;
    /** 签到时间（最新） */
    @ApiModelProperty("签到时间（最新）")
    private LocalDateTime signTime;
    /** 签到图片（最新） */
    @ApiModelProperty("签到图片（最新）")
    private String fileCodes;
    /** 拓展字段1 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 */
    @ApiModelProperty("拓展字段3")
    private String ext3;
}
