package com.elitesland.tw.tw5.api.common.funConfig.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 通用文档-文档类型访问权限
 *
 * @author duwh
 * @date 2023-12-10
 */
@Getter
@Setter
public class BusinessDocTypeConfigAllowRoleQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 文档类型配置主键 prd_business_doc_type_config.id 精确 */
    @ApiModelProperty("文档类型配置主键 prd_business_doc_type_config.id")
    private Long configId;
    /** 文档类型配置名称（冗余）prd_business_doc_type_config.name 精确 */
    @ApiModelProperty("文档类型配置名称（冗余）prd_business_doc_type_config.name")
    private String configName;
    /** 角色编码 精确 */
    @ApiModelProperty("角色编码")
    private String roleCode;
    /** 角色名称 精确 */
    @ApiModelProperty("角色名称")
    private String roleName;
    /** 拓展字段1 精确 */
    @ApiModelProperty("拓展字段1")
    private String ext1;
    /** 拓展字段2 精确 */
    @ApiModelProperty("拓展字段2")
    private String ext2;
    /** 拓展字段3 精确 */
    @ApiModelProperty("拓展字段3")
    private String ext3;

    public BusinessDocTypeConfigAllowRoleQuery(Long configId, String roleCode) {
        this.configId = configId;
        this.roleCode = roleCode;
    }
}
