package com.elitesland.tw.tw5.api.prd.acc.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * 报销科目配置与核算项目管理
 *
 * @author sunxw
 * @date 2023-12-15
 */
@Getter
@Setter
public class AccReimItemConfigRefQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 报销科目配置ID 精确
     */
    @ApiModelProperty("报销科目配置ID")
    private Long reimItemConfigId;
    /**
     * 核算项目 精确
     */
    @ApiModelProperty("核算项目")
    private Long busAccItemId;
    /**
     * 扩展字段1 精确
     */
    @ApiModelProperty("扩展字段1")
    private String extString1;
    /**
     * 扩展字段2 精确
     */
    @ApiModelProperty("扩展字段2")
    private String extString2;
    /**
     * 扩展字段3 精确
     */
    @ApiModelProperty("扩展字段3")
    private String extString3;

    @ApiModelProperty("报销科目配置ID集合")
    private List<Long> reimItemConfigIds;
}
