package com.elitesland.tw.tw5.api.prd.borrow.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.math.BigDecimal;
import java.util.List;

/**
 * 借款核销
 *
 * @author wangly
 * @date 2024-07-15
 */
@Getter
@Setter
public class BorrowWriteOffQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 借款ID 精确
     */
    @ApiModelProperty("借款ID")
    private Long borrowId;
    /**
     * 借款ID集合 精确
     */
    @ApiModelProperty("借款ID集合")
    private List<Long> borrowIdList;
    /**
     * 核销关联单据ID 精确
     */
    @ApiModelProperty("核销关联单据ID")
    private Long reimId;
    /**
     * 核销单据号 精确
     */
    @ApiModelProperty("核销单据号")
    private String reimNo;
    /**
     * 核销类型 [BORROW_MONEY:WRITE_OFF_TYPE] 精确
     */
    @ApiModelProperty("核销类型 [BORROW_MONEY:WRITE_OFF_TYPE]")
    private String writeOffType;
    /**
     * 核销单据名称 精确
     */
    @ApiModelProperty("核销单据名称")
    private String writeOffName;
    /**
     * 核销人ID 精确
     */
    @ApiModelProperty("核销人ID")
    private Long writeOffUserId;
    /**
     * 核销日期 精确
     */
    @ApiModelProperty("核销日期")
    private LocalDate writeOffDate;
    /**
     * 核销金额 精确
     */
    @ApiModelProperty("核销金额")
    private BigDecimal writeOffAmt;
    /**
     * 扩展字段1 精确
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2 精确
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3 精确
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字4 精确
     */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /**
     * 扩展字5 精确
     */
    @ApiModelProperty("扩展字5")
    private String ext5;
}
