package com.elitesland.tw.tw5.api.prd.borrow.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 出让申请
 *
 * @author wangly
 * @date 2024-07-15
 */
@Getter
@Setter
public class TransferApplyQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 借款ID 精确
     */
    @ApiModelProperty("借款ID")
    private Long borrowId;
    /**
     * 借款ID集合 精确
     */
    @ApiModelProperty("借款ID集合")
    private List<Long> borrowIdList;
    /**
     * 出让名称 精确
     */
    @ApiModelProperty("出让名称")
    private String transferName;
    /**
     * 出让人ID 精确
     */
    @ApiModelProperty("出让人ID")
    private Long transferUserId;
    /**
     * 出让日期 精确
     */
    @ApiModelProperty("出让日期")
    private LocalDate transferDate;
    /**
     * 出让人所属bu 精确
     */
    @ApiModelProperty("出让人所属bu")
    private Long transferBuId;
    /**
     * 受让人ID 精确
     */
    @ApiModelProperty("受让人ID")
    private Long receiveUserId;
    /**
     * 受让人所属bu 精确
     */
    @ApiModelProperty("受让人所属bu")
    private Long receiveBuId;
    /** 费用BU */
    @ApiModelProperty("费用BU")
    private Long costBuId;
    /**
     * 出让原因 精确
     */
    @ApiModelProperty("出让原因")
    private String transferReason;
    /**
     * 流程实例ID 精确
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /**
     * 流程审批状态 精确
     */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /**
     * 提交时间 精确
     */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /**
     * 审批时间 精确
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;
    /**
     * 扩展字段1 精确
     */
    @ApiModelProperty("扩展字段1")
    private String ext1;
    /**
     * 扩展字段2 精确
     */
    @ApiModelProperty("扩展字段2")
    private String ext2;
    /**
     * 扩展字段3 精确
     */
    @ApiModelProperty("扩展字段3")
    private String ext3;
    /**
     * 扩展字4 精确
     */
    @ApiModelProperty("扩展字4")
    private String ext4;
    /**
     * 扩展字5 精确
     */
    @ApiModelProperty("扩展字5")
    private String ext5;
}
