package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * 客户经营-经营团队成员
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
public class CrmCustomerOperationMemberPayload extends TwCommonPayload {

    /**
     * 客户经营主键
     */
    private Long operId;

    /**
     * 类型 默认值：TEMP 临时授权人员 ...
     */
    private String type;

    /**
     * 类型名称 默认值:临时授权人员
     */
    private String typeName;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户名字 冗余
     */
    private String userName;

    /**
     * 授权开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startTime;

    /**
     * 授权开始结束
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endTime;

    private String ext1;

    private String ext2;

    private String ext3;

    private String ext4;

    private String ext5;

}
