package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;

/**
 * 人脉
 *
 * @author carl
 * @date 2022/11/21
 */
@Data
public class CrmPeoplePayload extends TwCommonPayload {
    /**
     * 人脉经营主键 crm_customer_operation.id
     */
    private Long operId;
    /**
     * 客户表主键
     */
    private Long customerId;
    /**
     * 名称
     */
    private String peopleName;

    /**
     * 职位
     */
    private String jobs;

    /**
     * 生日
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate birthday;

    /**
     * 性别
     */
    private String sex;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 爱好标签:","分割字符串
     */
    private String tags;


    /**
     * 人脉地址-详细地址
     */
    private String locationDetail;

    /**
     * 爱心级别
     */
    private Integer loveLevel;


    /**
     * 微信
     */
    private String weChat;
    /**
     * 籍贯
     */
    private String birthplace;
    /**
     * 岗位情况
     */
    private String jobDetail;
    /**
     * 行业
     */
    private String industry;
    /**
     * 行业影响力
     */
    private String industryInfluence;

    /**
     * 部门
     */
    private String bu;
    /**
     * 社会身份
     */
    private String socialIdentity;

    /**
     * 婚姻状况0未婚，1已婚
     */
    private String marital;
    /**
     * 配偶岗位
     */
    private String spouseJobs;
    /**
     * 孩子年龄
     */
    private String childAge;
    /**
     * 父母健康
     */
    private String parentHealth;
    /**
     * 父母居住地
     */
    private String parentHabitation;

    /**
     * 状态
     */
    private String peopleStatus;
}
