package com.elitesland.tw.tw5.api.prd.crm.vo;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Author carl.wang
 * @Description 商机表
 * @Date
 **/
@SearchBean(
        tables = "crm_opportunity co " +
                "left join prj_project pp on co.project_id = pp.id " +
                "left join prj_project pp1 on co.act_id = pp1.id " +
                "left join crm_leads cl on co.leads_id = cl.id " +
                "left join person_plan ppl on co.id = ppl.obj_id and ppl.plan_type in('PRE_SALES','DELIVERY') " +
                "left join prj_project_member pm on pm.project_id = pp.id ",
        where = "pp.delete_flag = 0",
        groupBy = ":groupBy:",
        autoMapTo = "co"
)
@Data
@ApiModel("商机列表")
public class CrmOpportunityVO extends BaseViewModel {

    @ApiModelProperty("ID")
    private Long id;
    /**
     * 项目id
     */
    @ApiModelProperty("项目ID")
    private Long projectId;
    /**
     * 项目名称（名称）
     */
    @DbField(mapTo = "pp")
    @ApiModelProperty("项目名称")
    @FieldUpdateLog(fieldName = "项目名称")
    private String projectName;
    /**
     * 当量预估单价
     */
    @ApiModelProperty("当量预估单价")
    @DbIgnore
    private BigDecimal eqvaPrice;

    /**
     * 商机文件夹 对应在易稻壳itemId
     */
    @ApiModelProperty("商机文件ID")
    private String itemId;
    /**
     * 创建人（报备人）
     */
    @ApiModelProperty("创建人（报备人）")
    @DbIgnore
    @UdcName(udcName = "USER", codePropName = "createUserId")
    private String createUserName;

    /**
     * 活动id
     */
    @ApiModelProperty("活动id")
    private Long actId;

    /**
     * 活动名称
     */
    @DbField("pp1.project_name")
    @ApiModelProperty("活动名称")
    @FieldUpdateLog(fieldName = "活动名称")
    private String actName;

    /**
     * 项目编号（活动编号）
     */
    @DbField(mapTo = "pp")
    @ApiModelProperty("项目编号（活动编号）")
    private String projectNo;

    /**
     * 签单负责人id
     */
    @DbField(mapTo = "pp")
    @ApiModelProperty("签单负责人id")
    @FieldUpdateLog(fieldName = "签单负责人", selectionKey = "USER")
    private Long manageUserId;
    /**
     * 签单负责人
     */
    @DbIgnore
    @ApiModelProperty("签单负责人")
    private String manageUserName;
    /**
     * 签单buid
     */
    @DbField(mapTo = "pp")
    @ApiModelProperty("签单buid")
    @FieldUpdateLog(fieldName = "签单bu", selectionKey = "BU")
    private Long orgId;

    /**
     * 签单BU负责人Id
     */
    @DbIgnore
    @ApiModelProperty("签单BU负责人Id")
    private Long signBuManagerUserId;
    /**
     * 签单bu名称
     */
    @DbIgnore
    @ApiModelProperty("签单bu名称")
    private String orgName;
    /**
     * 公司id
     */
    @DbField(mapTo = "pp")
    @ApiModelProperty("公司id")
    private Long companyId;
    /**
     * 附件地址codes（“，”分割字符串）
     */
    @DbField(mapTo = "pp")
    @ApiModelProperty("附件地址codes")
    private String fileCodes;

    /**
     * 项目状态
     */
    @DbField(mapTo = "pp")
    @ApiModelProperty("项目状态")
    private String projectStatus;
    /**
     * 项目状态名称
     */
    @DbIgnore
    @ApiModelProperty("项目状态名称")
    private String projectStatusName;

    /**
     * 关闭原因
     */
    @DbField(mapTo = "pp")
    @ApiModelProperty("关闭原因")
    private String closeReason;
    /**
     * 关闭原因
     */
    @DbIgnore
    @ApiModelProperty("关闭原因名称")
    private String closeReasonName;
    /**
     * 丢单原因
     */
    @DbField(mapTo = "pp")
    @ApiModelProperty("丢单原因")
    private String loseReason;
    /**
     * 丢单原因
     */
    @DbIgnore
    @ApiModelProperty("丢单原因名称")
    private String loseReasonName;
    /**
     * 关闭备注
     */
    @DbField(mapTo = "pp")
    @ApiModelProperty("关闭备注")
    private String clsoeRemark;

    /**
     * 记录创建者ID
     */
    @DbField(mapTo = "pp")
    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    /**
     * 记录创建者
     */
    @DbField(mapTo = "pp")
    @ApiModelProperty("记录创建者")
    private String creator;

    /**
     * 记录创建时间
     */
    @DbField(mapTo = "pp")
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    /**
     * 线索id
     */
    @ApiModelProperty("线索id")
    private Long leadsId;
    /**
     * 线索名称
     */
    @DbField(mapTo = "cl")
    @ApiModelProperty("线索名称")
    private String leadsName;
    /**
     * 销售产品
     */
    @ApiModelProperty("销售产品")
    @FieldUpdateLog(fieldName = "销售产品")
    private String saleProduct;

    /**
     * 销售产品翻译
     */
    @ApiModelProperty("销售产品翻译")
    @DbIgnore
    @UdcName(udcName = "con:sales_class", codePropName = "saleProduct")
    private String saleProductDesc;
    /**
     * 客户区域
     */
    @ApiModelProperty("客户区域")
    @FieldUpdateLog(fieldName = "客户区域", selectionKey = "crm:customer_region")
    private String custRegion;
    /**
     * 客户区域名称
     */
    @DbIgnore
    @ApiModelProperty("客户区域名称")
    private String custRegionName;
    /**
     * 是否老客户 0:Y,1:N
     */
    @ApiModelProperty("是否老客户")
    @FieldUpdateLog(fieldName = "是否老客户", selectionKey = "crm:oppo:yn")
    private Integer isOldCust;

    @ApiModelProperty("是否老客户")
    @DbIgnore
    private String isOldCustStr;
    /**
     * 客户id 老客户才会选择
     */
    @ApiModelProperty("客户id 老客户才会选择")
    private Long custBookId;
    /**
     * 客户名称
     */
//    @DbIgnore
    @ApiModelProperty("客户名称")
    @FieldUpdateLog(fieldName = "客户名称")
    private String custBookName;
    /**
     * 客户项目
     */
    @ApiModelProperty("客户项目")
    @FieldUpdateLog(fieldName = "客户项目")
    private String custProject;
    /**
     * 客户联系人
     */
    @DbIgnore
    @ApiModelProperty("客户联系人")
    @FieldUpdateLog(fieldName = "客户联系人")
    private String contactName;
    /**
     * 客户联系电话
     */
    @ApiModelProperty("客户联系电话")
    @FieldUpdateLog(fieldName = "客户联系人电话")
    private String contactPhone;
    /**
     * 客户联系人部门
     */
    @ApiModelProperty("客户联系人部门")
    @FieldUpdateLog(fieldName = "客户联系人部门")
    private String contactDept;
    /**
     * 客户联系人岗位
     */
    @ApiModelProperty("客户联系人岗位")
    @FieldUpdateLog(fieldName = "客户联系人岗位")
    private String contactPosition;
    /**
     * 企业主页
     */
    @ApiModelProperty("企业主页")
    @FieldUpdateLog(fieldName = "企业主页")
    private String contactWebsite;
    /**
     * 客户性质
     */
    @ApiModelProperty("客户性质")
    @FieldUpdateLog(fieldName = "客户性质", selectionKey = "crm:company_nature")
    private String custProp;
    /**
     * 客户性质名称
     */
    @DbIgnore
    @ApiModelProperty("客户性质名称")
    private String custPropName;
    /**
     * 客户行业
     */
    @ApiModelProperty("客户行业")
    @FieldUpdateLog(fieldName = "客户行业", selectionKey = "crm:leads_customer_industry")
    private String custIdst;
    /**
     * 客户状态
     */
    @DbIgnore
    private String customerStatus;
    /**
     * 客户行业名稱
     */
    @DbIgnore
    @ApiModelProperty("客户行业名称")
    private String custIdstName;
    /**
     * 预计成单日期
     */
    @ApiModelProperty("预计成单日期")
    @FieldUpdateLog(fieldName = "预计签单时间")
    private LocalDate forecastWinDate;
    /**
     * 预计签单金额
     */
    @ApiModelProperty("预计签单金额")
    @FieldUpdateLog(fieldName = "预计签单金额")
    private BigDecimal forecastAmount;
    /**
     * 成单概率
     */
    @ApiModelProperty("成单概率")
    @FieldUpdateLog(fieldName = "成单概率", selectionKey = "crm:oppo:trans_proba")
    private String probability;
    /**
     * 成单概率不清楚原因
     */
    @DbIgnore
    @FieldUpdateLog(fieldName = "成单概率不清楚原因")
    private String probabilityHint;

    /**
     * 成单概率名称
     */
    @UdcName(udcName = "crm:oppo:trans_proba", codePropName = "probability")
    @ApiModelProperty("成单概率名称")
    @DbIgnore
    private String probabilityName;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 币种名称
     */
    @DbIgnore
    @ApiModelProperty("币种名称")
    private String currCodeName;
    /**
     * 销售阶段
     */
    @ApiModelProperty("销售阶段")
    @FieldUpdateLog(fieldName = "销售阶段", selectionKey = "crm:oppo:sale_stage")
    private String salePhase;
    /**
     * 销售阶段
     */
    @DbIgnore
    @ApiModelProperty("销售阶段名称")
    private String salePhaseName;
    /**
     * 交付地点
     */
    @ApiModelProperty("交付地点")
    @FieldUpdateLog(fieldName = "交付地点")
    private String deliveryAddress;
    /**
     * 商机级别
     */
    @ApiModelProperty("商机级别")
    @FieldUpdateLog(fieldName = "商机级别", selectionKey = "crm:oppo:level")
    private String oppoLevel;
    /**
     * 商机级别
     */
    @DbIgnore
    @ApiModelProperty("商机级别名称")
    private String oppoLevelName;
    /**
     * 是否需要合作伙伴 0:Y,1:N
     */
    @ApiModelProperty("是否需要合作伙伴")
    @FieldUpdateLog(fieldName = "是否需要合作伙伴", selectionKey = "crm:oppo:yn")
    private Integer isNeedPartner;
    /**
     * 关联合作伙伴Id
     */
    @ApiModelProperty("关联合作伙伴Id")
    private Long coopBookId;
    /**
     * 关联合作伙伴名称
     */
    @ApiModelProperty("关联合作伙伴名称")
    private String coopBookName;
    /**
     * 合作伙伴描述
     */
    @ApiModelProperty("合作伙伴描述")
    private String partnerDesc;
    /**
     * 售前bu
     */
    @ApiModelProperty("售前bu")
    @FieldUpdateLog(fieldName = "售前bu", selectionKey = "BU")
    private Long preSaleOrgId;
    /**
     * 售前bu
     */
    @DbIgnore
    @ApiModelProperty("售前bu名称")
    private String preSaleOrgName;
    /**
     * 售前负责人
     */
    @ApiModelProperty("售前负责人ID")
    @FieldUpdateLog(fieldName = "售前负责人", selectionKey = "USER")
    private Long preSaleUserId;
    /**
     * 售前负责人
     */
    @DbIgnore
    @ApiModelProperty("售前负责人名称")
    private String preSaleUserName;
    /**
     * 项目难度
     */
    @ApiModelProperty("项目难度")
    @FieldUpdateLog(fieldName = "项目难度", selectionKey = "crm:oppo:difficulty_level")
    private String projectDifficult;
    /**
     * 项目难度
     */
    @DbIgnore
    @ApiModelProperty("项目难度名称")
    private String projectDifficultName;
    /**
     * 项目重要度
     */
    @ApiModelProperty("项目重要度")
    @FieldUpdateLog(fieldName = "项目重要度", selectionKey = "crm:oppo:Importance")
    private String projectImportance;
    /**
     * 项目重要度
     */
    @DbIgnore
    @ApiModelProperty("项目重要度名称")
    private String projectImportanceName;
    /**
     * 交付BU_ID
     */
    @ApiModelProperty("交付BU_ID")
    @FieldUpdateLog(fieldName = "交付部门", selectionKey = "BU")
    private Long deliOrgId;
    /**
     * 交付bu
     */
    @DbIgnore
    @ApiModelProperty("交付bu名称")
    private String deliOrgName;
    /**
     * 交付负责人ID
     */
    @ApiModelProperty("交付负责人ID")
    @FieldUpdateLog(fieldName = "交付负责人", selectionKey = "USER")
    private Long deliUserId;
    /**
     * 交付负责人
     */
    @DbIgnore
    @ApiModelProperty("交付负责人")
    private String deliUserName;
    /**
     * 方案难度
     */
    @ApiModelProperty("方案难度")
    @FieldUpdateLog(fieldName = "方案难度", selectionKey = "crm:oppo:difficulty_level")
    private String solutionDifficulty;
    /**
     * 方案难度
     */
    @DbIgnore
    @ApiModelProperty("方案难度名称")
    private String solutionDifficultyName;
    /**
     * 方案重要度
     */
    @ApiModelProperty("方案重要度")
    @FieldUpdateLog(fieldName = "方案重要度", selectionKey = "crm:oppo:Importance")
    private String solutionImportance;
    /**
     * 方案重要度
     */
    @DbIgnore
    @ApiModelProperty("方案重要度名称")
    private String solutionImportanceName;
    /**
     * 合作(副)签单BU_ID
     */
    @ApiModelProperty("合作(副)签单BU_ID")
    @FieldUpdateLog(fieldName = "副签单部门", selectionKey = "BU")
    private Long coOrgId;
    /**
     * 合作(副)签单BU
     */
    @DbIgnore
    @ApiModelProperty("合作(副)签单BU名称")
    private String coOrgName;
    /**
     * 合作(副)签单负责人ID
     */
    @ApiModelProperty("合作(副)签单负责人ID")
    @FieldUpdateLog(fieldName = "副签单负责人", selectionKey = "USER")
    private Long coUserId;
    /**
     * 合作(副)签单负责人ID
     */
    @DbIgnore
    @ApiModelProperty("合作(副)签单负责人")
    private String coUserName;
    /**
     * 合作(副)交付BU_ID
     */
    @ApiModelProperty("合作(副)交付BU_ID")
    @FieldUpdateLog(fieldName = "副交付部门", selectionKey = "BU")
    private Long codeliOrgId;
    /**
     * 合作(副)交付BU
     */
    @DbIgnore
    @ApiModelProperty("合作(副)交付BU名称")
    private String codeliOrgName;
    /**
     * 合作(副)交付负责人ID
     */
    @ApiModelProperty("合作(副)交付负责人ID")
    @FieldUpdateLog(fieldName = "副交付负责人", selectionKey = "USER")
    private Long codeliUserId;
    /**
     * 合作(副)交付负责人
     */
    @DbIgnore
    @ApiModelProperty("合作(副)交付负责人")
    private String codeliUserName;
    /**
     * 来源类型
     */
    @ApiModelProperty("来源类型")
    private String sourceType;
    /**
     * 内部来源BU_ID
     */
    @ApiModelProperty("内部来源BU")
    private Long internalOrgId;
    /**
     * 内部来源BU
     */
    @DbIgnore
    @ApiModelProperty("内部来源BU名称")
    private String internalOrgName;
    /**
     * 内部来源人ID
     */
    @ApiModelProperty("内部来源人ID")
    private Long internalUserId;
    /**
     * 内部来源人ID
     */
    @DbIgnore
    @ApiModelProperty("内部来源人")
    private String internalUserName;
    /**
     * 外部线索来源
     */
    @ApiModelProperty("外部线索来源")
    private String externalIden;
    /**
     * 外部来源人
     */
    @ApiModelProperty("外部来源人")
    private String externalName;
    /**
     * 外部来源电话
     */
    @ApiModelProperty("外部来源电话")
    private String externalPhone;
    /**
     * 利益承诺
     */
    @ApiModelProperty("利益承诺")
    private String profitDesc;
    /**
     * 团队成员
     */
    @DbIgnore
    @ApiModelProperty("团队成员")
    private List<PrjProjectMemberVO> memberVOS;

    /**
     * 关联正式客户id
     */
    @ApiModelProperty("关联正式客户id")
    private Long formalCustomerId;

    @DbIgnore
    private String IsShow1;
    @DbIgnore
    private String IsShow2;
    @DbIgnore
    private String IsShow3;

    @ApiModelProperty("扩展字段1")
    private String extString1;
    @ApiModelProperty("扩展字段2")
    private String extString2;
    @ApiModelProperty("扩展字段3")
    private String extString3;
    @ApiModelProperty("扩展字段4")
    private String extString4;
    @ApiModelProperty("扩展字段5")
    private String extString5;

    @ApiModelProperty("oppoIdV4")
    private Long oppoIdV4;
    @DbIgnore
    private String order;
    @DbIgnore
    private String forecastWinDateStr;
    @DbIgnore
    private String isNeedPartnerStr;
    @DbIgnore
    private String members;
    @DbIgnore
    private String createDateStr;
    /**
     * 验证状态
     */
    @ApiModelProperty("验证状态")
    private String checkStatus;
    @DbIgnore
    @UdcName(udcName = "crm:oppo:check_status", codePropName = "checkStatus")
    @ApiModelProperty("验证状态名称")
    private String checkStatusName;

    /**
     * 需求产品归属部门
     */
    @DbIgnore
    @ApiModelProperty("需求产品归属部门")
    private Long demandProductOrg;
    @DbIgnore
    @UdcName(udcName = "BU", codePropName = "demandProductOrg")
    @ApiModelProperty("需求产品归属部门名称")
    private String demandProductOrgDesc;

    /**
     * 市场渠道
     */
    @DbIgnore
    @ApiModelProperty("市场渠道")
    private String marketChannel;
    @DbIgnore
    @UdcName(udcName = "crm:leads_channel", codePropName = "marketChannel")
    @ApiModelProperty("市场渠道名称")
    private String marketChannelDesc;

    //==============补充字段==============

    /**
     * 是否实施过本公司产品
     */
    @ApiModelProperty("是否实施本公司产品")
    private Long isImplementation;
    /**
     * 实施情况
     */
    @ApiModelProperty("实施情况")
    private String implementCondition;
    /**
     * 上线要求
     */
    @ApiModelProperty("上线要求")
    private String onboarding;
    /**
     * 项目预算情况
     */
    @ApiModelProperty("项目预算情况")
    private String proResource;
    /**
     * 项目发起原因
     */
    @ApiModelProperty("项目发起原因")
    private String proInitiateReason;
    /**
     * 项目关键决策人描述
     */
    @ApiModelProperty("项目关键决策人描述")
    private String proPolicymakerDesc;
    /**
     * 接触部门描述
     */
    @ApiModelProperty("接触部门描述")
    @DbIgnore
    private String contactBUDesc;
    /**
     * 涉及本公司产品与服务
     */
    @ApiModelProperty("涉及本公司产品与服务")
    private String productServe;
    /**
     * 对标客户
     */
    @ApiModelProperty("对标客户")
    private String benchmarkingCust;
    /**
     * 客户年营业额（万元）
     */
    @ApiModelProperty("客户年营业额（万元）")
    private String custTurnoverYear;
    /**
     * 是否是上市公司
     */
    @ApiModelProperty("是否是上市公司")
    private Long isListedCompany;
    /**
     * 方案情况(UDC)
     */
    @ApiModelProperty("方案情况(UDC)")
    private String programSituation;
    @DbIgnore
    @UdcName(udcName = "crm:oppo:program_situation", codePropName = "programSituation")
    private String programSituationDesc;
    /**
     * 团队资源(UDC)
     */
    @ApiModelProperty("团队资源(UDC)")
    private String teamResources;
    @DbIgnore
    @UdcName(udcName = "crm:oppo:team_resource", codePropName = "teamResources")
    private String teamResourcesDesc;
    /**
     * 商务资源(UDC)
     */
    @ApiModelProperty("商务资源(UDC)")
    private String businessResources;
    @DbIgnore
    @UdcName(udcName = "crm:oppo:business_resources", codePropName = "businessResources")
    private String businessResourcesDesc;
    /**
     * 副售前负责人
     */
    @ApiModelProperty("副售前负责人")
    private Long codePreSaleUserId;
    @DbIgnore
    @UdcName(udcName = "USER", codePropName = "codePreSaleUserId")
    private String codePreSaleUserName;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId = 0L;

    /**
     * 记录最后更新者
     */
    @ApiModelProperty("记录最后更新者")
    private String updater;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    /**
     * 逻辑删除标识
     */
    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag = 0;

    /**
     * 锁版本
     */
    @ApiModelProperty(value = "锁版本")
    private Integer auditDataVersion;

    /**
     * 成本估算权限（商机资源规划权限）
     */
    @ApiModelProperty(value = "成本估算权限（商机资源规划权限）")
    @DbIgnore
    private Boolean personPlanAuth;


    /**
     * 资源规划id
     */
    @DbField("ppl.id")
    @ApiModelProperty("资源规划id")
    private Long planId;

    @DbField(mapTo = "ppl")
    @ApiModelProperty("planType")
    private String planType;

    @DbIgnore
    @ApiModelProperty("BU名称")
    private String buName;

    @DbIgnore
    @ApiModelProperty("评级")
    private String grade;


    @DbIgnore
    @ApiModelProperty("累计投入当量")
    private BigDecimal usedEqva = BigDecimal.ZERO;


    @DbIgnore
    @ApiModelProperty("累计投入费用")
    private BigDecimal usedAmt = BigDecimal.ZERO;

    @ApiModelProperty("personPlanFlag")
    @DbField("ppl.id")
    private Long personPlanFlag;

    @ApiModelProperty("上级主管部门")
    private String parentManageBu;
}
