package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import lombok.Data;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;
import java.util.List;

import io.swagger.annotations.ApiModel;
import com.elitescloud.boot.common.param.BaseViewModel;


/**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板
 */

@Data
@ApiModel(description = "绩效考核模板")
public class PrdExamTempVO extends BaseViewModel {


    /**
     * 模板名称
     */
    @ApiModelProperty("模板名称")
    private String name;

    /**
     * 分数上限
     */
    @ApiModelProperty("分数上限")
    private BigDecimal scoreMax;

    /**
     * 分数下限
     */
    @ApiModelProperty("分数下限")
    private BigDecimal scoreMin;

    /**
     * 启用标志
     */
    @ApiModelProperty("启用标志")
    private Boolean enableFlag;

    /**
     * 考核结果等级列表
     */
    @ApiModelProperty("考核结果等级列表")
    private List<PrdExamTempGradeVO> prdExamTempGradeVOList;

    /**
     * 考核点列表
     */
    @ApiModelProperty("考核点列表")
    private List<PrdExamTempPointVO> prdExamTempPointVOList;

}

