package com.elitesland.tw.tw5.api.prd.my.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * JDE员工月度工时统计
 *
 * @author likunpeng
 * @date 2024/5/11
 */
@Data
@ExcelIgnoreUnannotated
public class JDEMonthlyTimesheetVO implements Serializable {
    /**
     * 年度【JDE-年度】
     */
    @ExcelProperty(value = "年度", index = 0)
    private String year;
    /**
     * 月度【JDE-期间】
     */
    @ExcelProperty(value = "月度", index = 1)
    private String monthly;
    /**
     * 参考合同号【JDE-项目成本中心】
     */
    @ExcelProperty(value = "参考合同号", index = 2)
    private String refContractNo;
    /**
     * 合同号【JDE-REP项目编号】
     */
    @ExcelProperty(value = "合同号", index = 3)
    private String contractNo;
    /**
     * 员工编号【JDE员工编号】
     */
    @ExcelProperty(value = "员工编号", index = 4)
    private String resNo;
    /**
     * 天数【JDE-实际工作的天数】
     */
    @ExcelProperty(value = "天数", index = 5)
    private BigDecimal days;
    /**
     * 当量系数【JDE-系数】
     */
    @ExcelProperty(value = "当量系数", index = 6)
    private BigDecimal eqvaRatio;
    /**
     * 结算当量【JDE-结算当量】
     */
    @ExcelProperty(value = "结算当量", index = 7)
    private BigDecimal settleEqva;
    /**
     * 项目属性【JDE-工时类型】
     */
    @ExcelProperty(value = "项目属性", index = 8)
    private String pjType1;
}
