package com.elitesland.tw.tw5.api.prd.partner.common.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 业务伙伴-账户信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Getter
@Setter
public class BookAccountQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /**
     * 地址薄id 精确
     */
    @ApiModelProperty("地址薄id")
    private Long bookId;
    /**
     * 账户类型 udc[prd:ab:account_type] 精确
     */
    @ApiModelProperty("账户类型 udc[prd:ab:account_type]")
    private String accountType;

    /**
     * 账户用途 udc[prd:ab:account_usage]
     */
    @ApiModelProperty("账户用途 udc[prd:ab:account_usage]")
    private String accountUsage;

    /**
     * 银行 udc[prd:ab:bank_name] 精确
     */
    @ApiModelProperty("银行 udc[prd:ab:bank_name]")
    private String depositBank;
    /**
     * 开户地 精确
     */
    @ApiModelProperty("开户地")
    private String depositCity;
    /**
     * 开户网点 精确
     */
    @ApiModelProperty("开户网点")
    private String depositBankOutlet;
    /**
     * 户名 精确
     */
    @ApiModelProperty("户名")
    private String accountName;
    /**
     * 账户号 精确
     */
    @ApiModelProperty("账户号")
    private String accountNo;
    /**
     * 币种 udc[SYSTEM_BASIC:CURRENCY] 精确
     */
    @ApiModelProperty("币种 udc[SYSTEM_BASIC:CURRENCY]")
    private String currency;
    /**
     * 是否为默认账户  精确
     */
    @ApiModelProperty("是否为默认账户 ")
    private Boolean isDefault;
}
