package com.elitesland.tw.tw5.api.prd.pms.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;

/**
 * 项目事件日志功能管理
 *
 * @author carl
 * @date 2023-09-18
 */
@Getter
@Setter
public class PmsProjectEventLogQuery extends TwQueryParam implements Serializable {
    /**
     * 记录唯一ID 精确
     */
    @ApiModelProperty("记录唯一ID")
    private List<Long> ids;
    /**
     * 项目主键 精确
     */
    @ApiModelProperty("项目主键")
    private Long projectId;
    /**
     * 项目名称或编号搜索
     */
    @ApiModelProperty("项目名称或编号搜索")
    private String projSearch;
    /**
     * 事件内容及来源 精确
     */
    @ApiModelProperty("事件内容及来源")
    private String eventContentSource;
    /**
     * 可能产生的影响 模糊
     */
    @ApiModelProperty("可能产生的影响")
    private String possibleImpacts;
    /**
     * 所属类型 精确
     */
    @ApiModelProperty("所属类型")
    private String type;
    /**
     * 严重程度 精确
     */
    @ApiModelProperty("严重程度")
    private String severity;
    /**
     * 发生几率 精确
     */
    @ApiModelProperty("发生几率")
    private String probabilityOfOccurrence;
    /**
     * 风险程度 精确
     */
    @ApiModelProperty("风险程度")
    private String riskLevel;
    /**
     * 应对策略 模糊
     */
    @ApiModelProperty("应对策略")
    private String copingStrategy;
    /**
     * 预计结束时间 精确
     */
    @ApiModelProperty("预计结束时间")
    private LocalDate expectedEndDate;
    /**
     * 负责人 精确
     */
    @ApiModelProperty("负责人")
    private Long headResId;
    /**
     * 状态 精确
     */
    @ApiModelProperty("状态")
    private String status;
    /**
     * 组织id 精确
     */
    @ApiModelProperty("组织id")
    private List<Long> headOrgIds;

    /**
     * 项目经理资源id
     */
    @ApiModelProperty("项目经理资源id")
    private Long pmResId;
    /**
     * 交付BU_ID
     */
    @ApiModelProperty("交付BU_ID")
    private Long deliBuId;

    /**
     * 项目状态 精确
     */
    @ApiModelProperty("项目状态")
    private String projectStatus;
}
