package com.elitesland.tw.tw5.api.prd.salecon.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 业绩统计
 *
 * @author likunpeng
 * @date 2023-04-24
 */
@Getter
@Setter
public class ConAchievePayload extends TwCommonPayload  implements Serializable {
    /** 合同ID */
    @ApiModelProperty("合同ID")
    private Long contractId;
    /** 签单额（合同含税总金额） */
    @ApiModelProperty("签单额")
    private BigDecimal amt;
    /** 税率 */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /** 折算后有效销售额 */
    @ApiModelProperty("折算后有效销售额")
    private BigDecimal obversionEffectiveAmt;
    /** 业绩统计状态 */
    @ApiModelProperty("业绩统计状态")
    private String achieveStatus;
    private Long achieveIdV4;
    /** 平台提成比例 */
    @ApiModelProperty("平台提成比例")
    private BigDecimal percentage;
    /** 业绩统计明细 */
    @ApiModelProperty("业绩统计明细")
    private List<ConAchieveDPayload> conAchieveDPayloads;
}
