package com.elitesland.tw.tw5.api.prd.salecon.service;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConTemplatePayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConTemplateQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConTemplateVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 合同模板
 *
 * @author likunpeng
 * @date 2023-04-17
 */
public interface ConTemplateService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link ConTemplateVO}>
     */
    PagingVO<ConTemplateVO> queryPaging(ConTemplateQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link ConTemplateVO}>
     */
    List<ConTemplateVO> queryListDynamic(ConTemplateQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link ConTemplateVO}
     */
    ConTemplateVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link ConTemplateVO}
     */
    ConTemplateVO insert(ConTemplatePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link ConTemplateVO}
     */
    ConTemplateVO update(ConTemplatePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 逻辑删除
     * @param key 主键
     */
    void deleteById(Long key);
}
