package com.elitesland.tw.tw5.api.prd.acc.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 报销金额来源记录管理
 *
 * @author sunxw
 * @date 2023-12-04
 */
@Getter
@Setter
public class AccReimSourceRecordPayload extends TwCommonPayload implements Serializable {
    /**
     * 报销主表ID
     */
    @ApiModelProperty("报销主表ID")
    private Long reimId;
    /**
     * 报销明细ID
     */
    @ApiModelProperty("报销明细ID")
    private Long reimDtlId;
    /**
     * 报销规则ID
     */
    @ApiModelProperty("报销规则ID")
    private Long ruleId;
    /**
     * 报销内容详情(JSON)
     */
    @ApiModelProperty("报销内容详情")
    private AccReimSourcePayload source;

    @ApiModelProperty("报销内容详情(JSON)")
    private String content;

}
