package com.elitesland.tw.tw5.api.prd.adm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmBusitripApplyPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmBusitripApplyQuery;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmBusitripApplyVO;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;

import java.util.List;

/**
 * 出差申请管理
 *
 * @author carl
 * @date 2023-10-30
 */
public interface AdmBusitripApplyService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link AdmBusitripApplyVO}>
     */
    PagingVO<AdmBusitripApplyVO> queryPaging(AdmBusitripApplyQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link AdmBusitripApplyVO}>
     */
    List<AdmBusitripApplyVO> queryListDynamic(AdmBusitripApplyQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link AdmBusitripApplyVO}
     */
    AdmBusitripApplyVO queryByKey(Long key);

    /**
     * 新增或修改
     *
     * @param payload 单据数据
     * @return {@link AdmBusitripApplyVO}
     */
    AdmBusitripApplyVO insertOrUpdate(AdmBusitripApplyPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link AdmBusitripApplyVO}
     */
    AdmBusitripApplyVO update(AdmBusitripApplyPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(AdmBusitripApplyPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 流程回调
     *
     * @param payload
     */
    void processStatusChange(ProcessStatusChangePayload payload);

    /**
     * 根据注解获取(仅查询)
     *
     * @param key
     * @return
     */
    AdmBusitripApplyVO queryOneByKey(Long key);

    /**
     * 解除报销绑定
     * @param reimId
     */
    void unbindReim(Long reimId);
}
