package com.elitesland.tw.tw5.api.prd.administration.service;

import com.elitesland.tw.tw5.api.prd.administration.payload.CertificationLicensePayload;
import com.elitesland.tw.tw5.api.prd.administration.query.CertificationLicenseQuery;
import com.elitesland.tw.tw5.api.prd.administration.vo.CertificationLicenseVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 资质证照
 *
 * @author wangly
 * @date 2023-09-20
 */
public interface CertificationLicenseService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CertificationLicenseVO}>
     */
    PagingVO<CertificationLicenseVO> queryPaging(CertificationLicenseQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CertificationLicenseVO}>
     */
    List<CertificationLicenseVO> queryListDynamic(CertificationLicenseQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CertificationLicenseVO}
     */
    CertificationLicenseVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CertificationLicenseVO}
     */
    CertificationLicenseVO insert(CertificationLicensePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link CertificationLicenseVO}
     */
    CertificationLicenseVO update(CertificationLicensePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(CertificationLicensePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 资质证照过期提醒
     *
     */
    void certificationLicenseInvaildAlter();

}
