package com.elitesland.tw.tw5.api.prd.app.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * APP版本管理
 *
 * @author duwh
 * @date 2023-02-23
 */
@Getter
@Setter
public class AppVersionQuery extends TwQueryParam implements Serializable {
    /**
     * 版本名称 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String name;
    /**
     * 版本号 精确
     */
    @Query
    private Integer version;
    /**
     * 更新日志 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String content;
    /**
     * 强制更新标记，0：不强制更新，1：强制更新 精确
     */
    @Query
    private Integer forceFlag;
    /**
     * 文件地址code(安卓安卓包) 精确
     */
    @Query
    private String fileCode;
    /**
     * 下载地址（安卓安装包） 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String downloadUrl;

    /**
     * 是否展示 0 不展示  1展示
     */
    @Query
    private Integer showFlag;
    /**
     * ALL 所有；Android 安卓； IOS 苹果手机 精确
     */
    @Query
    private String type;
    /**
     * 拓展1 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String ext1;
    /**
     * 拓展2 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String ext2;
    /**
     * 拓展3 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String ext3;
    /**
     * 拓展4 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String ext4;
    /**
     * 拓展5 模糊
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String ext5;
}
