package com.elitesland.tw.tw5.api.prd.cal.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 核算-账户流水记录管理
 *
 * @author carl
 * @date 2023-11-13
 */
@Getter
@Setter
@ToString
public class CalAccountTurnoverPayload extends TwCommonPayload implements Serializable {
    /**
     * 账户id
     */
    @ApiModelProperty("账户id")

    private Long accId;
    /**
     * 账户名称（冗余）
     */
    @ApiModelProperty("账户名称（冗余）")
    private String accName;
    /**
     * 核算年度
     */
    @ApiModelProperty("核算年度")
    private Integer finYear;
    /**
     * 核算期间
     */
    @ApiModelProperty("核算期间")
    private Integer finPeriod;
    /**
     * 交易期间
     */
    @ApiModelProperty("交易期间")
    private LocalDate ioDate;
    /**
     * 交易时间
     */
    @ApiModelProperty("交易时间")
    private LocalDateTime ioTime;
    /**
     * 交易单据类型
     */
    @ApiModelProperty("交易单据类型")
    private String sourceType;
    /**
     * 交易单据id
     */
    @ApiModelProperty("交易单据id")
    private Long sourceId;
    /**
     * 交易单据名称（冗余）
     */
    @ApiModelProperty("交易单据名称（冗余）")
    private String sourceName;
    /**
     * 交易当量
     */
    @ApiModelProperty("交易当量")
    private BigDecimal turnoverQty;
    /**
     * 交易金额
     */
    @ApiModelProperty("交易金额")
    private BigDecimal turnoverAmt;
    /**
     * 当量价格
     */
    @ApiModelProperty("当量价格")
    private BigDecimal eqvaPrice;
    /**
     * 交易前当量
     */
    @ApiModelProperty("交易前当量")
    private BigDecimal beforeQty;
    /**
     * 交易后当量
     */
    @ApiModelProperty("交易后当量")
    private BigDecimal afterQty;
    /**
     * 交易前金额
     */
    @ApiModelProperty("交易前金额")
    private BigDecimal beforeAmt;
    /**
     * 交易后金额
     */
    @ApiModelProperty("交易后金额")
    private BigDecimal afterAmt;
}
