package com.elitesland.tw.tw5.api.prd.cal.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalNormSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalNormSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalNormSettleVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 泛用金额结算管理
 *
 * @author carl
 * @date 2023-11-20
 */
public interface CalNormSettleService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link CalNormSettleVO}>
     */
    PagingVO<CalNormSettleVO> queryPaging(CalNormSettleQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link CalNormSettleVO}>
     */
    List<CalNormSettleVO> queryListDynamic(CalNormSettleQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CalNormSettleVO}
     */
    CalNormSettleVO queryByKey(Long key);

    /**
     * 新增或修改
     *
     * @param payload 单据数据
     * @return {@link CalNormSettleVO}
     */
    CalNormSettleVO insertOrUpdate(CalNormSettlePayload payload);

//    /**
//     * 修改
//     *
//     * @param payload 单据数据
//     * @return {@link CalNormSettleVO}
//     */
//    CalNormSettleVO update(CalNormSettlePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(CalNormSettlePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 取消过账
     *
     * @param key 主键
     */
    void cancelNorm(Long key);

    /**
     * 导出模板
     *
     * @param response 请求响应
     */
    void downloadPlus(HttpServletResponse response);

    /**
     * 批量立项导入excel
     *
     * @param file 请求响应
     */
    boolean batchImport(MultipartFile file);
}
