package com.elitesland.tw.tw5.api.prd.cal.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * 核算-账户冻结记录管理
 *
 * @author carl
 * @date 2023-11-13
 */
@Getter
@Setter
public class CalAccountFreezeVO extends BaseViewModel implements Serializable {
    /**
     * 账户id
     */
    @ApiModelProperty("账户id")

    private Long accId;
    /**
     * 账户名称（冗余）
     */
    @ApiModelProperty("账户名称（冗余）")
    private String accName;
    /**
     * 核算年度
     */
    @ApiModelProperty("核算年度")
    private Integer finYear;
    /**
     * 核算期间
     */
    @ApiModelProperty("核算期间")
    private Integer finPeriod;
    /**
     * 交易期间
     */
    @ApiModelProperty("交易期间")
    private LocalDate ioDate;
    /**
     * 交易时间
     */
    @ApiModelProperty("交易时间")
    private LocalDateTime ioTime;
    /**
     * 交易单据类型
     */
    @ApiModelProperty("交易单据类型")
    private String sourceType;
    @UdcName(udcName = "CAL:ACC:TURNOVER", codePropName = "sourceType")
    private String sourceTypeDesc;
    /**
     * 交易单据id
     */
    @ApiModelProperty("交易单据id")
    private Long sourceId;
    /**
     * 交易单据名称（冗余）
     */
    @ApiModelProperty("交易单据名称（冗余）")
    private String sourceName;
    /**
     * 冻结当量
     */
    @ApiModelProperty("冻结当量")
    private BigDecimal freezeQty;
    /**
     * 冻结金额
     */
    @ApiModelProperty("冻结金额")
    private BigDecimal freezeAmt;
    /**
     * 当量价格
     */
    @ApiModelProperty("当量价格")
    private BigDecimal eqvaPrice;
    /**
     * 交易前当量
     */
    @ApiModelProperty("交易前当量")
    private BigDecimal beforeQty;
    /**
     * 交易后当量
     */
    @ApiModelProperty("交易后当量")
    private BigDecimal afterQty;
    /**
     * 交易前金额
     */
    @ApiModelProperty("交易前金额")
    private BigDecimal beforeAmt;
    /**
     * 交易后金额
     */
    @ApiModelProperty("交易后金额")
    private BigDecimal afterAmt;
}
