package com.elitesland.tw.tw5.api.prd.copartner.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 合伙人绩效自述表
 *
 * @author carl
 * @date 2024-06-24
 */
@Getter
@Setter
public class PerformanceReadmeUserDetailVO extends BaseViewModel implements Serializable {
    /**
     * 配置主键
     */
    @ApiModelProperty("配置主键")
    private Long configId;
    /**
     * 配置详情主键
     */
    @ApiModelProperty("配置详情主键")
    private Long configDetailId;
    /**
     * 员工详情主键
     */
    @Comment("员工详情主键")
    @Column()
    private Long configUserId;
    /**
     * 员工主键
     */
    @ApiModelProperty("员工主键")
    private Long userId;
    /**
     * 合同id
     */
    @ApiModelProperty("合同id")
    private Long contractId;
    /**
     * 合同名称
     */
    @ApiModelProperty("合同名称")
    private String contractName;
    /**
     * 项目id
     */
    @ApiModelProperty("项目id")
    private Long projectId;
    /**
     * 项目名称
     */
    @ApiModelProperty("项目名称")
    private String projectName;
    /**
     * 合同类型
     */
    @ApiModelProperty("合同类型")
    private String contractType;
    @UdcName(udcName = "org:employee:copartner:contract_type", codePropName = "contractType")
    private String contractTypeDesc;
    /**
     * 商机id
     */
    @ApiModelProperty("商机id")
    private Long oppoId;
    /**
     * 商机名称
     */
    @ApiModelProperty("商机名称")
    private String oppoName;
    /**
     * 业务种类
     */
    @ApiModelProperty("业务种类")
    private String businessType;
    @UdcName(udcName = "org:employee:copartner:business_type", codePropName = "businessType")
    private String businessTypeDesc;
    /**
     * 签单金额
     */
    @ApiModelProperty("签单金额")
    private BigDecimal amount;
    /**
     * 签单金额（不含税）
     */
    @ApiModelProperty("签单金额（不含税）")
    private BigDecimal amountNoTax;
    /**
     * 签单销售人员id
     */
    @ApiModelProperty("签单销售人员id")
    private Long saleUserId;
    @UdcName(udcName = "USER", codePropName = "saleUserId")
    private String saleUserName;
    /**
     * 工时总人天
     */
    @ApiModelProperty("工时总人天")
    private BigDecimal totalDays;
    /**
     * 工时售前人天
     */
    @ApiModelProperty("工时售前人天")
    private BigDecimal preSaleDays;
    /**
     * 售前支持角色
     */
    @ApiModelProperty("售前支持角色")
    private String preSaleRole;
    @UdcName(udcName = "org:employee:copartner:pre_sale_role", codePropName = "preSaleRole")
    private String preSaleRoleDesc;
    /**
     * 工时商务人天
     */
    @ApiModelProperty("工时商务人天")
    private BigDecimal businessDays;
    /**
     * 商务支持角色
     */
    @ApiModelProperty("商务支持角色")
    private String businessRole;
    @UdcName(udcName = "org:employee:copartner:business_role", codePropName = "businessRole")
    private String businessRoleDesc;
    /**
     * 工时交付人天
     */
    @ApiModelProperty("工时交付人天")
    private BigDecimal deliDays;
    /**
     * 交付支持角色
     */
    @ApiModelProperty("交付支持角色")
    private String deliRole;
    @UdcName(udcName = "org:employee:copartner:deli_role", codePropName = "deliRole")
    private String deliRoleDesc;
    /**
     * 分配比例
     */
    @ApiModelProperty("分配比例")
    private String ratio;
    /**
     * 分配金额
     */
    @ApiModelProperty("分配金额")
    private BigDecimal amt;

    /**
     * 业绩统计明细ID
     */
    @ApiModelProperty("业绩统计明细ID")
    private Long achieveDId;
    /**
     * 商机状态
     */
    @ApiModelProperty("商机状态")
    private String oppoStatus;
    @UdcName(udcName = "org:employee:copartner:pre_sale_status", codePropName = "oppoStatus")
    private String oppoStatusDesc;
    /**
     * 任务名称
     */
    @ApiModelProperty("任务名称")
    private String taskName;
    /**
     * 任务类型
     */
    @ApiModelProperty("任务类型")
    private String taskType;
    @UdcName(udcName = "org:employee:copartner:task_type", codePropName = "taskType")
    private String taskTypeDesc;
    /**
     * 受惠事业部
     */
    @ApiModelProperty("受惠事业部")
    private Long incomeBuId;
    @UdcName(udcName = "BU", codePropName = "incomeBuId")
    private String incomeBuName;
    /**
     * 任务角色
     */
    @ApiModelProperty("任务角色")
    private String taskRole;
    @UdcName(udcName = "org:employee:copartner:task_role", codePropName = "taskRole")
    private String taskRoleDesc;
    /**
     * 任务描述
     */
    @ApiModelProperty("任务描述")
    private String taskDetail;
    /**
     * 任务收益描述
     */
    @ApiModelProperty("任务收益描述")
    private String taskIncomeDesc;

    /**
     * 自动还是手动创建0:自动，1：手动
     */
    @ApiModelProperty("自动还是手动创建")
    private Integer createFlag;
    /**
     * 拓展字符串1
     */
    @ApiModelProperty("拓展字符串1")
    private String extStr1;

    /**
     * 拓展字符串2
     */
    @ApiModelProperty("拓展字符串2")
    private String extStr2;

    /**
     * 拓展字符串3(任务类型)
     */
    @ApiModelProperty("拓展字符串3(任务类型)")
    private String extStr3;
    /**
     * 拓展字符串4
     */
    @ApiModelProperty("拓展字符串4")
    private String extStr4;
    /**
     * 拓展字符串5
     */
    @ApiModelProperty("拓展字符串5")
    private String extStr5;
    /**
     * 拓展数字1
     */
    @ApiModelProperty("拓展数字1")
    private BigDecimal extNumber1;
    /**
     * 拓展数字2
     */
    @ApiModelProperty("拓展数字2")
    private BigDecimal extNumber2;
    /**
     * 拓展数字3
     */
    @ApiModelProperty("拓展数字3")
    private BigDecimal extNumber3;
    /**
     * 拓展主键1
     */
    @ApiModelProperty("拓展主键1")
    private Long extKey1;
    @UdcName(udcName = "USER", codePropName = "extKey1")
    private String extKey1Name;
    /**
     * 拓展主键2
     */
    @ApiModelProperty("拓展主键2")
    private Long extKey2;
    @UdcName(udcName = "USER", codePropName = "extKey2")
    private String extKey2Name;
    /**
     * 拓展主键3
     */
    @ApiModelProperty("拓展主键3")
    private Long extKey3;
    @UdcName(udcName = "BU", codePropName = "extKey3")
    private String extKey3Name;

    /**
     * 事由id
     */
    @ApiModelProperty("事由id")
    private Long reasonId;
    /**
     * 事由类型
     */
    @ApiModelProperty("事由类型")
    private String reasonType;
}
