package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;

/**
 * @Author carl.wang
 * @Description 市场活动表
 * @Date
 **/

@Data

public class CrmActActivityQuery extends TwQueryParam {

    /**
     * 活动id列表
     */
    private Long[] activityIds;

    /**
     * 计划Id
     */
    private Long planId;

    /**
     * 计划明细id
     */
    private Long detailId;
    /**
     * 项目名称（活动名称）
     */
    private String projectName;
    /**
     * 项目编号（活动编号）
     */
    private String projectNo;

    /**
     * 项目时间（活动时间）
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate projectTime;

    /**
     * 负责人id
     */
    private Long manageUserId;
    /**
     * 组织（部门，BU）id
     */
    private Long orgId;
    /**
     * 项目状态（活动状态）
     */
    private String projectStatus;
    /**
     * 是否发布了公告，未发布：0，不发布：1，已发布：2
     */
    private Integer isRelease = 0;

    /**
     * 项目时间年月
     */
    private String yearMonth;
    
    private LocalDate yearMonthDate;
}
