package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class PersonAccountVO extends BaseViewModel {

    @ApiModelProperty("自然人ID")
    private Long personId;

    @ApiModelProperty("账户类型")
    private String accType;
    @UdcName(udcName = "prd:ab:account_type", codePropName = "accType")
    private String accTypeName;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户状态")
    private String accStatus;

    @ApiModelProperty("是否工资卡")
    private Boolean defaultFlag;

    @ApiModelProperty("币种")
    private String currCode;
    @UdcName(udcName = "SYSTEM_BASIC:CURRENCY", codePropName = "currCode")
    private String currCodeName;

    @ApiModelProperty("开户银行")
    private String bankName;

    @ApiModelProperty("开户地")
    private String bankCity;
    @UdcName(udcName = "SYSTEM_BASIC:PCD", codePropName = "bankCity")
    private String bankCityName;

    @ApiModelProperty("开户网点")
    private String bankBranch;

    @ApiModelProperty("开户人")
    private String holderName;

    @ApiModelProperty("卡号")
    private String accountNo;
}
