package com.elitesland.tw.tw5.api.prd.humanresources.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class ResEntryExitLogVO extends BaseViewModel {

    @ApiModelProperty("员工ID")
    private Long employeeId;

    @ApiModelProperty("编号")
    private Long logNo;

    @ApiModelProperty("类型1")
    private String reasonType1;

    @ApiModelProperty("类型2")
    private String reasonType2;
    @UdcName(udcName = "org:employee:entryLeaveType", codePropName = "reasonType2")
    private String reasonType2Name;

    @ApiModelProperty("事由ID")
    private Long reasonId;

    @ApiModelProperty("入职 离职日期")
    private String entryExitDate;

    @ApiModelProperty("资源类型")
    private String resType;
    @UdcName(udcName = "org:employee:type", codePropName = "resType")
    private String resTypeName;

    @ApiModelProperty("公司")
    private Long bookId;

    @ApiModelProperty("公司名称")
    private String companyName;

    @ApiModelProperty("组织")
    private Long orgId;
    @UdcName(udcName = "BU", codePropName = "orgId")
    private String orgName;

    @ApiModelProperty("城市")
    private String baseCity;
    @UdcName(udcName = "org:employee:serviceaddr", codePropName = "baseCity")
    private String baseCityName;

    @ApiModelProperty("合作方式")
    private String coopType;
    @UdcName(udcName = "org:employee:COOPERATION_MODE", codePropName = "coopType")
    private String coopTypeName;

    @ApiModelProperty("工作")
    private String job;

    @ApiModelProperty("资源状态")
    private String resClass;

    @ApiModelProperty("离职原因")
    private String leaveReason;
    @UdcName(udcName = "org:employee:leaveReason", codePropName = "leaveReason")
    private String leaveReasonName;

    @ApiModelProperty("离职说明")
    private String leaveReasonDesc;
}
