package com.elitesland.tw.tw5.api.prd.my.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

@Getter
@Setter
public class RewardLeaveApplyDetailPayload extends TwCommonPayload implements Serializable {
    /**
     * 申请单id
     */
    @ApiModelProperty("申请单id")
    private Long applyId;
    /**
     * 资源userId
     */
    @ApiModelProperty("资源userId")
    private Long userId;
    /**
     * 职级
     */
    @ApiModelProperty("职级")
    private String jobGrade;

    /**
     * 管理职级
     */
    @ApiModelProperty("管理职级")
    private String jobGrade2;
    /**
     * 资源组织Id
     */
    @ApiModelProperty("资源组织Id")
    private Long orgId;
    /**
     * 工作日期
     */
    @ApiModelProperty("工作日期")
    private LocalDate workDate;
    /**
     * 工作类型
     */
    @ApiModelProperty("工作类型")
    private String workType;
    /**
     * 奖励假天数
     */
    @ApiModelProperty("奖励假天数")
    private BigDecimal days;
    /**
     * 理论当量
     */
    @ApiModelProperty("理论当量")
    private BigDecimal eqva;
    /**
     * 已申请天数
     */
    @ApiModelProperty("已申请天数")
    private BigDecimal appliedDays;
}
