package com.elitesland.tw.tw5.api.prd.my.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;

import java.util.List;

/**
* 工时用-项目表
*
* @author duwh
* @date 2022-12-09
*/
@Data
public class ProjectQuery extends TwQueryParam{

    /**
     * 关键字
     */
    @Query(blurry = "projName,projNo")
    private String keyword;
    /** 项目idv4 精确 */
    @Query
    private Long projIdV4;
    /** 项目idv4 不等于精确 */
    @Query(type = Query.Type.NOT_EQUAL, propName = "projIdV4")
    private Long projIdV4NotEqual;

    /** 项目idv4 IN */
    @Query(type = Query.Type.IN, propName = "projIdV4")
    private List<Long> projIdV4List;
    /** 项目名称 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String projName;
    /** 项目编号 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String projNo;
    /**
        项目状态：
        CREATE("CREATE", "新建"),
        CHECK("CHECK","审核中"),
        CHECK_OK("CHECK_OK","审核通过"),
        CHECK_NO("CHECK_NO","审核驳回"),
        APPROVING("APPROVING","派发中"),
        ACTIVE("ACTIVE","激活"),
        PENDING("PENDING","暂挂"),
        CLOSE("CLOSE","关闭");
      精确 */
    @Query
    private String projStatus;
    /** 合同主键 精确 */
    @Query
    private Long contractId;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String relatedProjNo;
    /** 产品号 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String productNo;


    /**
     * 经营类项目  ext1= OPER
     */
    @Query
    private String ext1;
    @Query(type = Query.Type.NOT_EQUAL, propName = "ext1")
    private String ext1NotEqual;
    /**
     * 经营类项目  ext2等于交付BU 组织主键
     */
    @Query
    private String ext2;

    /**
     * 是否需要权限判断
     */
    private Boolean isPermission = true;
}
